/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config;

import com.azure.spring.cloud.config.AppConfigurationCredentialProvider;
import com.azure.spring.cloud.config.AppConfigurationPropertySourceLocator;
import com.azure.spring.cloud.config.ConfigurationClientBuilderSetup;
import com.azure.spring.cloud.config.KeyVaultCredentialProvider;
import com.azure.spring.cloud.config.KeyVaultSecretProvider;
import com.azure.spring.cloud.config.SecretClientBuilderSetup;
import com.azure.spring.cloud.config.properties.AppConfigurationProperties;
import com.azure.spring.cloud.config.properties.AppConfigurationProviderProperties;
import com.azure.spring.cloud.config.properties.ConfigStore;
import com.azure.spring.cloud.config.resource.AppConfigManagedIdentityProperties;
import com.azure.spring.cloud.config.resource.Connection;
import com.azure.spring.cloud.config.resource.ConnectionPool;
import com.azure.spring.cloud.config.stores.ClientStore;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={AppConfigurationProperties.class, AppConfigurationProviderProperties.class})
@ConditionalOnClass(value={AppConfigurationPropertySourceLocator.class})
@ConditionalOnProperty(prefix="spring.cloud.azure.appconfiguration", name={"enabled"}, matchIfMissing=true)
public class AppConfigurationBootstrapConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationBootstrapConfiguration.class);

    @Bean
    public ConnectionPool initConnectionString(AppConfigurationProperties properties) {
        ConnectionPool pool = new ConnectionPool();
        List<ConfigStore> stores = properties.getStores();
        for (ConfigStore store : stores) {
            if (store.isEnabled() && StringUtils.hasText((String)store.getEndpoint()) && StringUtils.hasText((String)store.getConnectionString())) {
                pool.put(store.getEndpoint(), new Connection(store.getConnectionString()));
                continue;
            }
            if (!StringUtils.hasText((String)store.getEndpoint())) continue;
            AppConfigManagedIdentityProperties msiProps = properties.getManagedIdentity();
            if (msiProps != null && msiProps.getClientId() != null) {
                pool.put(store.getEndpoint(), new Connection(store.getEndpoint(), msiProps.getClientId()));
                continue;
            }
            pool.put(store.getEndpoint(), new Connection(store.getEndpoint(), ""));
        }
        Assert.notEmpty(pool.getAll(), (String)"Connection string pool for the configuration stores is empty");
        return pool;
    }

    @Bean
    public AppConfigurationPropertySourceLocator sourceLocator(AppConfigurationProperties properties, AppConfigurationProviderProperties appProperties, ClientStore clients, Optional<KeyVaultCredentialProvider> keyVaultCredentialProviderOptional, Optional<SecretClientBuilderSetup> keyVaultClientProviderOptional, Optional<KeyVaultSecretProvider> keyVaultSecretProviderOptional) throws IllegalArgumentException {
        KeyVaultCredentialProvider keyVaultCredentialProvider = null;
        SecretClientBuilderSetup keyVaultClientProvider = null;
        KeyVaultSecretProvider keyVaultSecretProvider = null;
        if (!keyVaultCredentialProviderOptional.isPresent()) {
            LOGGER.debug("No KeyVaultCredentialProvider found.");
        } else {
            keyVaultCredentialProvider = keyVaultCredentialProviderOptional.get();
        }
        if (!keyVaultClientProviderOptional.isPresent()) {
            LOGGER.debug("No KeyVaultCredentialProvider found.");
        } else {
            keyVaultClientProvider = keyVaultClientProviderOptional.get();
        }
        if (!keyVaultSecretProviderOptional.isPresent()) {
            LOGGER.debug("No KeyVaultSecretProvider found.");
        } else {
            keyVaultSecretProvider = keyVaultSecretProviderOptional.get();
        }
        if (keyVaultClientProvider != null && keyVaultSecretProvider != null) {
            throw new IllegalArgumentException("KeyVaultClientProvider and KeyVaultSecretProvider both can't have Beans supplied.");
        }
        return new AppConfigurationPropertySourceLocator(properties, appProperties, clients, keyVaultCredentialProvider, keyVaultClientProvider, keyVaultSecretProvider);
    }

    @Bean
    public ClientStore buildClientStores(AppConfigurationProperties properties, AppConfigurationProviderProperties appProperties, ConnectionPool pool, Environment env, Optional<AppConfigurationCredentialProvider> tokenCredentialProviderOptional, Optional<ConfigurationClientBuilderSetup> clientProviderOptional, Optional<KeyVaultCredentialProvider> keyVaultCredentialProviderOptional, Optional<SecretClientBuilderSetup> keyVaultClientProviderOptional) {
        AppConfigurationCredentialProvider tokenCredentialProvider = null;
        ConfigurationClientBuilderSetup clientProvider = null;
        if (!tokenCredentialProviderOptional.isPresent()) {
            LOGGER.debug("No AppConfigurationCredentialProvider found.");
        } else {
            tokenCredentialProvider = tokenCredentialProviderOptional.get();
        }
        if (!clientProviderOptional.isPresent()) {
            LOGGER.debug("No AppConfigurationClientProvider found.");
        } else {
            clientProvider = clientProviderOptional.get();
        }
        boolean isDev = false;
        boolean isKeyVaultConfigured = false;
        List<String> profiles = Arrays.asList(env.getActiveProfiles());
        for (String profile : profiles) {
            if (!profile.equalsIgnoreCase("dev")) continue;
            isDev = true;
        }
        if (keyVaultCredentialProviderOptional.isPresent() || keyVaultClientProviderOptional.isPresent()) {
            isKeyVaultConfigured = true;
        }
        return new ClientStore(appProperties, pool, tokenCredentialProvider, clientProvider, isDev, isKeyVaultConfigured);
    }
}

