/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.stores;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.policy.ExponentialBackoff;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.RetryStrategy;
import com.azure.core.http.rest.PagedIterable;
import com.azure.data.appconfiguration.ConfigurationClient;
import com.azure.data.appconfiguration.ConfigurationClientBuilder;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.spring.cloud.config.AppConfigurationCredentialProvider;
import com.azure.spring.cloud.config.ConfigurationClientBuilderSetup;
import com.azure.spring.cloud.config.NormalizeNull;
import com.azure.spring.cloud.config.pipline.policies.BaseAppConfigurationPolicy;
import com.azure.spring.cloud.config.properties.AppConfigurationProviderProperties;
import com.azure.spring.cloud.config.resource.Connection;
import com.azure.spring.cloud.config.resource.ConnectionPool;
import java.time.Duration;
import java.util.HashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class ClientStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientStore.class);
    private final AppConfigurationProviderProperties appProperties;
    private final ConnectionPool pool;
    private final AppConfigurationCredentialProvider tokenCredentialProvider;
    private final ConfigurationClientBuilderSetup clientProvider;
    private final HashMap<String, ConfigurationClient> clients;
    private final boolean isDev;
    private final boolean isKeyVaultConfigurated;

    public ClientStore(AppConfigurationProviderProperties appProperties, ConnectionPool pool, AppConfigurationCredentialProvider tokenCredentialProvider, ConfigurationClientBuilderSetup clientProvider, Boolean isDev, Boolean isKeyVaultConfigured) {
        this.appProperties = appProperties;
        this.pool = pool;
        this.tokenCredentialProvider = tokenCredentialProvider;
        this.clientProvider = clientProvider;
        this.clients = new HashMap();
        this.isDev = isDev;
        this.isKeyVaultConfigurated = isKeyVaultConfigured;
    }

    private ConfigurationClient getClient(String store) throws IllegalArgumentException {
        if (this.clients.containsKey(store)) {
            return this.clients.get(store);
        }
        ExponentialBackoff retryPolicy = new ExponentialBackoff(this.appProperties.getMaxRetries(), Duration.ofMillis(800L), Duration.ofSeconds(8L));
        ConfigurationClientBuilder builder = this.getBuilder().addPolicy((HttpPipelinePolicy)new BaseAppConfigurationPolicy(this.isDev, this.isKeyVaultConfigurated)).retryPolicy((HttpPipelinePolicy)new RetryPolicy((RetryStrategy)retryPolicy));
        TokenCredential tokenCredential = null;
        Connection connection = this.pool.get(store);
        String endpoint = Optional.ofNullable(connection).map(Connection::getEndpoint).orElse(null);
        if (this.tokenCredentialProvider != null) {
            tokenCredential = this.tokenCredentialProvider.getAppConfigCredential(endpoint);
        }
        String clientId = Optional.ofNullable(connection).map(Connection::getClientId).orElse(null);
        boolean clientIdIsPresent = StringUtils.hasText((String)clientId);
        boolean tokenCredentialIsPresent = tokenCredential != null;
        boolean connectionStringIsPresent = Optional.ofNullable(connection).map(Connection::getConnectionString).filter(StringUtils::hasText).isPresent();
        boolean endPointIsPresent = Optional.ofNullable(connection).map(Connection::getEndpoint).filter(StringUtils::hasText).isPresent();
        if ((tokenCredentialIsPresent || clientIdIsPresent) && connectionStringIsPresent) {
            throw new IllegalArgumentException("More than 1 Conncetion method was set for connecting to App Configuration.");
        }
        if (tokenCredential != null && clientIdIsPresent) {
            throw new IllegalArgumentException("More than 1 Conncetion method was set for connecting to App Configuration.");
        }
        if (tokenCredential != null) {
            LOGGER.debug("Connecting to " + endpoint + " using AppConfigurationCredentialProvider.");
            builder.credential(tokenCredential);
        } else if (clientIdIsPresent && endPointIsPresent) {
            LOGGER.debug("Connecting to " + endpoint + " using Client ID from configuration file.");
            ManagedIdentityCredentialBuilder micBuilder = new ManagedIdentityCredentialBuilder().clientId(clientId);
            builder.credential((TokenCredential)micBuilder.build());
        } else if (connectionStringIsPresent) {
            LOGGER.debug("Connecting to " + endpoint + " using Connecting String.");
            builder.connectionString(connection.getConnectionString());
        } else if (endPointIsPresent) {
            LOGGER.debug("Connecting to " + endpoint + " using Azure System Assigned Identity or Azure User Assigned Identity.");
            ManagedIdentityCredentialBuilder micBuilder = new ManagedIdentityCredentialBuilder();
            builder.credential((TokenCredential)micBuilder.build());
        } else {
            throw new IllegalArgumentException("No Configuration method was set for connecting to App Configuration");
        }
        builder.endpoint(endpoint);
        if (this.clientProvider != null) {
            this.clientProvider.setup(builder, endpoint);
        }
        this.clients.put(store, builder.buildClient());
        return this.clients.get(store);
    }

    public ConfigurationSetting getWatchKey(String key, String label, String storeName) {
        return NormalizeNull.normalizeNullLabel(this.getClient(storeName).getConfigurationSetting(key, label));
    }

    public PagedIterable<ConfigurationSetting> getFeatureFlagWatchKey(SettingSelector settingSelector, String storeName) {
        return this.getClient(storeName).listConfigurationSettings(settingSelector);
    }

    public PagedIterable<ConfigurationSetting> listSettings(SettingSelector settingSelector, String storeName) {
        return this.getClient(storeName).listConfigurationSettings(settingSelector);
    }

    ConfigurationClientBuilder getBuilder() {
        return new ConfigurationClientBuilder();
    }
}

