/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.implementation;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.spring.cloud.config.KeyVaultCredentialProvider;
import com.azure.spring.cloud.config.KeyVaultSecretProvider;
import com.azure.spring.cloud.config.SecretClientBuilderSetup;
import com.azure.spring.cloud.config.feature.management.entity.FeatureSet;
import com.azure.spring.cloud.config.implementation.AppConfigurationPropertySource;
import com.azure.spring.cloud.config.implementation.AppConfigurationRefreshUtil;
import com.azure.spring.cloud.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.config.implementation.AppConfigurationReplicaClientFactory;
import com.azure.spring.cloud.config.implementation.AppConfigurationStatusException;
import com.azure.spring.cloud.config.implementation.BackoffTimeCalculator;
import com.azure.spring.cloud.config.implementation.StateHolder;
import com.azure.spring.cloud.config.properties.AppConfigurationProperties;
import com.azure.spring.cloud.config.properties.AppConfigurationProviderProperties;
import com.azure.spring.cloud.config.properties.AppConfigurationStoreSelects;
import com.azure.spring.cloud.config.properties.AppConfigurationStoreTrigger;
import com.azure.spring.cloud.config.properties.ConfigStore;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public final class AppConfigurationPropertySourceLocator
implements PropertySourceLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationPropertySourceLocator.class);
    private static final String PROPERTY_SOURCE_NAME = "azure-config-store";
    private static final String REFRESH_ARGS_PROPERTY_SOURCE = "refreshArgs";
    private final AppConfigurationProperties properties;
    private final List<ConfigStore> configStores;
    private final AppConfigurationProviderProperties appProperties;
    private final AppConfigurationReplicaClientFactory clientFactory;
    private final KeyVaultCredentialProvider keyVaultCredentialProvider;
    private final SecretClientBuilderSetup keyVaultClientProvider;
    private final KeyVaultSecretProvider keyVaultSecretProvider;
    static final AtomicBoolean STARTUP = new AtomicBoolean(true);

    public AppConfigurationPropertySourceLocator(AppConfigurationProperties properties, AppConfigurationProviderProperties appProperties, AppConfigurationReplicaClientFactory clientFactory, KeyVaultCredentialProvider keyVaultCredentialProvider, SecretClientBuilderSetup keyVaultClientProvider, KeyVaultSecretProvider keyVaultSecretProvider) {
        this.properties = properties;
        this.appProperties = appProperties;
        this.configStores = properties.getStores();
        this.clientFactory = clientFactory;
        this.keyVaultCredentialProvider = keyVaultCredentialProvider;
        this.keyVaultClientProvider = keyVaultClientProvider;
        this.keyVaultSecretProvider = keyVaultSecretProvider;
        BackoffTimeCalculator.setDefaults(appProperties.getDefaultMaxBackoff(), appProperties.getDefaultMinBackoff());
    }

    public PropertySource<?> locate(Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return null;
        }
        ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
        boolean currentlyLoaded = env.getPropertySources().stream().anyMatch(source -> {
            String storeName = this.configStores.get(0).getEndpoint();
            AppConfigurationStoreSelects selectedKey = this.configStores.get(0).getSelects().get(0);
            return source.getName().startsWith("bootstrapProperties-" + selectedKey.getKeyFilter() + storeName + "/");
        });
        if (currentlyLoaded && !env.getPropertySources().contains(REFRESH_ARGS_PROPERTY_SOURCE)) {
            return null;
        }
        List<String> profiles = Arrays.asList(env.getActiveProfiles());
        CompositePropertySource composite = new CompositePropertySource(PROPERTY_SOURCE_NAME);
        Collections.reverse(this.configStores);
        StateHolder newState = new StateHolder();
        newState.setNextForcedRefresh(this.properties.getRefreshInterval());
        Iterator<ConfigStore> configStoreIterator = this.configStores.iterator();
        while (configStoreIterator.hasNext()) {
            boolean loadNewPropertySources;
            ConfigStore configStore = configStoreIterator.next();
            boolean bl = loadNewPropertySources = STARTUP.get() || StateHolder.getLoadState(configStore.getEndpoint());
            if (configStore.isEnabled() && loadNewPropertySources) {
                FeatureSet featureSet = new FeatureSet();
                List<AppConfigurationReplicaClient> clients = this.clientFactory.getAvailableClients(configStore.getEndpoint(), true);
                boolean generatedPropertySources = false;
                ArrayList<AppConfigurationPropertySource> sourceList = new ArrayList<AppConfigurationPropertySource>();
                boolean reloadFailed = false;
                for (AppConfigurationReplicaClient client : clients) {
                    sourceList = new ArrayList();
                    if (!STARTUP.get() && reloadFailed && !AppConfigurationRefreshUtil.checkStoreAfterRefreshFailed(client, this.clientFactory, configStore.getFeatureFlags())) continue;
                    try {
                        sourceList.addAll(this.create(client, configStore, profiles, !configStoreIterator.hasNext(), featureSet));
                        LOGGER.debug("PropertySource context.");
                        List<ConfigurationSetting> watchKeysSettings = this.getWatchKeys(client, configStore.getMonitoring().getTriggers());
                        List<ConfigurationSetting> watchKeysFeatures = this.getFeatureFlagWatchKeys(client, configStore, newState);
                        if (watchKeysFeatures.size() > 0) {
                            newState.setStateFeatureFlag(configStore.getEndpoint(), watchKeysFeatures, configStore.getMonitoring().getFeatureFlagRefreshInterval());
                            newState.setLoadStateFeatureFlag(configStore.getEndpoint(), true);
                        } else {
                            newState.setLoadStateFeatureFlag(configStore.getEndpoint(), false);
                        }
                        newState.setState(configStore.getEndpoint(), watchKeysSettings, configStore.getMonitoring().getRefreshInterval());
                        newState.setLoadState(configStore.getEndpoint(), true);
                        generatedPropertySources = true;
                    }
                    catch (AppConfigurationStatusException e) {
                        reloadFailed = true;
                        this.clientFactory.backoffClient(configStore.getEndpoint(), client.getEndpoint());
                    }
                    catch (Exception e) {
                        newState = this.failedToGeneratePropertySource(configStore, newState, e);
                        break;
                    }
                    if (!generatedPropertySources) continue;
                    break;
                }
                if (generatedPropertySources) {
                    sourceList.forEach(arg_0 -> ((CompositePropertySource)composite).addPropertySource(arg_0));
                    continue;
                }
                if (STARTUP.get() && (!configStore.isFailFast() || !STARTUP.get())) continue;
                String message = "Failed to generate property sources for " + configStore.getEndpoint();
                this.failedToGeneratePropertySource(configStore, newState, new RuntimeException(message));
                continue;
            }
            if (!configStore.isEnabled() && loadNewPropertySources) {
                LOGGER.info("Not loading configurations from {} as it is not enabled.", (Object)configStore.getEndpoint());
                continue;
            }
            LOGGER.warn("Not loading configurations from {} as it failed on startup.", (Object)configStore.getEndpoint());
        }
        StateHolder.updateState(newState);
        STARTUP.set(false);
        return composite;
    }

    private List<ConfigurationSetting> getWatchKeys(AppConfigurationReplicaClient client, List<AppConfigurationStoreTrigger> triggers) {
        ArrayList<ConfigurationSetting> watchKeysSettings = new ArrayList<ConfigurationSetting>();
        for (AppConfigurationStoreTrigger trigger : triggers) {
            ConfigurationSetting watchKey = client.getWatchKey(trigger.getKey(), trigger.getLabel());
            if (watchKey != null) {
                watchKeysSettings.add(watchKey);
                continue;
            }
            watchKeysSettings.add(new ConfigurationSetting().setKey(trigger.getKey()).setLabel(trigger.getLabel()));
        }
        return watchKeysSettings;
    }

    private List<ConfigurationSetting> getFeatureFlagWatchKeys(AppConfigurationReplicaClient client, ConfigStore configStore, StateHolder newState) {
        List<ConfigurationSetting> watchKeysFeatures = new ArrayList<ConfigurationSetting>();
        if (configStore.getFeatureFlags().getEnabled().booleanValue()) {
            SettingSelector settingSelector = new SettingSelector().setKeyFilter(configStore.getFeatureFlags().getKeyFilter()).setLabelFilter(configStore.getFeatureFlags().getLabelFilter());
            watchKeysFeatures = client.listConfigurationSettings(settingSelector);
        }
        return watchKeysFeatures;
    }

    private StateHolder failedToGeneratePropertySource(ConfigStore configStore, StateHolder newState, Exception e) {
        String message = "Failed to generate property sources for " + configStore.getEndpoint();
        if (!STARTUP.get()) {
            LOGGER.error("Refreshing failed while reading configuration from Azure App Configuration store " + configStore.getEndpoint() + ".");
            if (this.properties.getRefreshInterval() != null) {
                newState.updateNextRefreshTime(this.properties.getRefreshInterval(), this.appProperties.getDefaultMinBackoff());
            }
            throw new RuntimeException(message, e);
        }
        if (configStore.isFailFast()) {
            LOGGER.error("Fail fast is set and there was an error reading configuration from Azure App Configuration store " + configStore.getEndpoint() + ".");
            this.delayException();
            throw new RuntimeException(message, e);
        }
        LOGGER.warn("Unable to load configuration from Azure AppConfiguration store " + configStore.getEndpoint() + ".", (Throwable)e);
        newState.setLoadState(configStore.getEndpoint(), false);
        return newState;
    }

    private List<AppConfigurationPropertySource> create(AppConfigurationReplicaClient client, ConfigStore store, List<String> profiles, boolean initFeatures, FeatureSet featureSet) throws Exception {
        ArrayList<AppConfigurationPropertySource> sourceList = new ArrayList<AppConfigurationPropertySource>();
        List<AppConfigurationStoreSelects> selects = store.getSelects();
        for (AppConfigurationStoreSelects selectedKeys : selects) {
            AppConfigurationPropertySource propertySource = new AppConfigurationPropertySource(store, selectedKeys, profiles, this.properties, client, this.appProperties, this.keyVaultCredentialProvider, this.keyVaultClientProvider, this.keyVaultSecretProvider);
            propertySource.initProperties(featureSet);
            if (initFeatures) {
                propertySource.initFeatures(featureSet);
            }
            sourceList.add(propertySource);
        }
        return sourceList;
    }

    private void delayException() {
        Instant preKillTIme;
        Instant currentDate = Instant.now();
        if (currentDate.isBefore(preKillTIme = this.appProperties.getStartDate().plusSeconds(this.appProperties.getPrekillTime()))) {
            long diffInMillies = Math.abs(preKillTIme.toEpochMilli() - currentDate.toEpochMilli());
            try {
                Thread.sleep(diffInMillies);
            }
            catch (InterruptedException e) {
                LOGGER.error("Failed to wait before fast fail.");
            }
        }
    }
}

