/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.implementation;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

final class JsonConfigurationParser {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    JsonConfigurationParser() {
    }

    static boolean isJsonContentType(String contentType) {
        String acceptedMainType = "application";
        String acceptedSubType = "json";
        if (!StringUtils.hasText((String)contentType)) {
            return false;
        }
        if (contentType.contains("/")) {
            String mainType = contentType.split("/")[0];
            String subType = contentType.split("/")[1];
            if (mainType.equalsIgnoreCase(acceptedMainType)) {
                if (subType.contains("+")) {
                    List<String> subtypes = Arrays.asList(subType.split("\\+"));
                    return subtypes.contains(acceptedSubType);
                }
                return subType.equalsIgnoreCase(acceptedSubType);
            }
        }
        return false;
    }

    static Map<String, Object> parseJsonSetting(ConfigurationSetting setting) throws JsonProcessingException {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        JsonNode json = MAPPER.readTree(setting.getValue());
        JsonConfigurationParser.parseSetting(setting.getKey(), json, settings);
        return settings;
    }

    static void parseSetting(String currentKey, JsonNode currentValue, HashMap<String, Object> settings) {
        switch (currentValue.getNodeType()) {
            case ARRAY: {
                for (int i = 0; i < currentValue.size(); ++i) {
                    String newKey = currentKey + "[" + i + "]";
                    JsonConfigurationParser.parseSetting(newKey, currentValue.get(i), settings);
                }
                break;
            }
            case OBJECT: {
                Iterator fieldNames = currentValue.fieldNames();
                while (fieldNames.hasNext()) {
                    String fieldName = (String)fieldNames.next();
                    String newKey = currentKey + "." + fieldName;
                    JsonConfigurationParser.parseSetting(newKey, currentValue.get(fieldName), settings);
                }
                break;
            }
            default: {
                settings.put(currentKey, currentValue.asText());
            }
        }
    }
}

