/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.properties;

import com.azure.spring.cloud.config.properties.AppConfigurationProviderProperties;
import com.azure.spring.cloud.config.properties.ConfigStore;
import com.azure.spring.cloud.config.resource.AppConfigManagedIdentityProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotEmpty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Import;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="spring.cloud.azure.appconfiguration")
@Import(value={AppConfigurationProviderProperties.class})
public final class AppConfigurationProperties {
    public static final String CONFIG_PREFIX = "spring.cloud.azure.appconfiguration";
    public static final String LABEL_SEPARATOR = ",";
    @NotEmpty
    private String defaultContext = "application";
    private boolean enabled = true;
    private List<ConfigStore> stores = new ArrayList<ConfigStore>();
    private String name;
    @NestedConfigurationProperty
    private AppConfigManagedIdentityProperties managedIdentity;
    private boolean pushRefresh = true;
    private Duration refreshInterval;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<ConfigStore> getStores() {
        return this.stores;
    }

    public void setStores(List<ConfigStore> stores) {
        this.stores = stores;
    }

    @Deprecated
    public String getDefaultContext() {
        return this.defaultContext;
    }

    @Deprecated
    public void setDefaultContext(String defaultContext) {
        this.defaultContext = defaultContext;
    }

    @Deprecated
    @Nullable
    public String getName() {
        return this.name;
    }

    @Deprecated
    public void setName(@Nullable String name) {
        this.name = name;
    }

    public AppConfigManagedIdentityProperties getManagedIdentity() {
        return this.managedIdentity;
    }

    public void setManagedIdentity(AppConfigManagedIdentityProperties managedIdentity) {
        this.managedIdentity = managedIdentity;
    }

    public Boolean getPushRefresh() {
        return this.pushRefresh;
    }

    public void setPushRefresh(Boolean pushRefresh) {
        this.pushRefresh = pushRefresh;
    }

    public Duration getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(Duration refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    @PostConstruct
    public void validateAndInit() {
        Assert.notEmpty(this.stores, (String)"At least one config store has to be configured.");
        this.stores.forEach(store -> {
            Assert.isTrue((StringUtils.hasText((String)store.getEndpoint()) || StringUtils.hasText((String)store.getConnectionString()) || store.getEndpoints().size() > 0 || store.getConnectionStrings().size() > 0 ? 1 : 0) != 0, (String)"Either configuration store name or connection string should be configured.");
            store.validateAndInit();
        });
        HashMap<String, Boolean> existingEndpoints = new HashMap<String, Boolean>();
        for (ConfigStore store2 : this.stores) {
            if (store2.getEndpoints().size() > 0) {
                for (String endpoint : store2.getEndpoints()) {
                    if (existingEndpoints.containsKey(endpoint)) {
                        throw new IllegalArgumentException("Duplicate store name exists.");
                    }
                    existingEndpoints.put(endpoint, true);
                }
                continue;
            }
            if (!StringUtils.hasText((String)store2.getEndpoint())) continue;
            if (existingEndpoints.containsKey(store2.getEndpoint())) {
                throw new IllegalArgumentException("Duplicate store name exists.");
            }
            existingEndpoints.put(store2.getEndpoint(), true);
        }
        if (this.refreshInterval != null) {
            Assert.isTrue((this.refreshInterval.getSeconds() >= 1L ? 1 : 0) != 0, (String)"Minimum refresh interval time is 1 Second.");
        }
    }
}

