/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config;

import com.azure.core.http.rest.PagedIterable;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.spring.cloud.config.AppConfigurationPropertySource;
import com.azure.spring.cloud.config.KeyVaultCredentialProvider;
import com.azure.spring.cloud.config.KeyVaultSecretProvider;
import com.azure.spring.cloud.config.NormalizeNull;
import com.azure.spring.cloud.config.SecretClientBuilderSetup;
import com.azure.spring.cloud.config.StateHolder;
import com.azure.spring.cloud.config.feature.management.entity.FeatureSet;
import com.azure.spring.cloud.config.properties.AppConfigurationProperties;
import com.azure.spring.cloud.config.properties.AppConfigurationProviderProperties;
import com.azure.spring.cloud.config.properties.AppConfigurationStoreSelects;
import com.azure.spring.cloud.config.properties.AppConfigurationStoreTrigger;
import com.azure.spring.cloud.config.properties.ConfigStore;
import com.azure.spring.cloud.config.stores.ClientStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public final class AppConfigurationPropertySourceLocator
implements PropertySourceLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationPropertySourceLocator.class);
    private static final String SPRING_APP_NAME_PROP = "spring.application.name";
    private static final String PROPERTY_SOURCE_NAME = "azure-config-store";
    private static final String REFRESH_ARGS_PROPERTY_SOURCE = "refreshArgs";
    private static final String PATH_SPLITTER = "/";
    private final AppConfigurationProperties properties;
    private final List<ConfigStore> configStores;
    private final Map<String, List<String>> storeContextsMap = new ConcurrentHashMap<String, List<String>>();
    private final AppConfigurationProviderProperties appProperties;
    private final ClientStore clients;
    private final KeyVaultCredentialProvider keyVaultCredentialProvider;
    private final SecretClientBuilderSetup keyVaultClientProvider;
    private final KeyVaultSecretProvider keyVaultSecretProvider;
    private static AtomicBoolean configloaded = new AtomicBoolean(false);
    private static AtomicBoolean startup = new AtomicBoolean(true);

    public AppConfigurationPropertySourceLocator(AppConfigurationProperties properties, AppConfigurationProviderProperties appProperties, ClientStore clients, KeyVaultCredentialProvider keyVaultCredentialProvider, SecretClientBuilderSetup keyVaultClientProvider, KeyVaultSecretProvider keyVaultSecretProvider) {
        this.properties = properties;
        this.appProperties = appProperties;
        this.configStores = properties.getStores();
        this.clients = clients;
        this.keyVaultCredentialProvider = keyVaultCredentialProvider;
        this.keyVaultClientProvider = keyVaultClientProvider;
        this.keyVaultSecretProvider = keyVaultSecretProvider;
    }

    public PropertySource<?> locate(Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return null;
        }
        ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
        if (configloaded.get() && !env.getPropertySources().contains(REFRESH_ARGS_PROPERTY_SOURCE)) {
            return null;
        }
        String applicationName = this.properties.getName();
        if (!StringUtils.hasText((String)applicationName)) {
            applicationName = env.getProperty(SPRING_APP_NAME_PROP);
        }
        List<String> profiles = Arrays.asList(env.getActiveProfiles());
        CompositePropertySource composite = new CompositePropertySource(PROPERTY_SOURCE_NAME);
        Collections.reverse(this.configStores);
        Iterator<ConfigStore> configStoreIterator = this.configStores.iterator();
        while (configStoreIterator.hasNext()) {
            ConfigStore configStore = configStoreIterator.next();
            Boolean loadNewPropertySources = startup.get() || StateHolder.getLoadState(configStore.getEndpoint());
            if (configStore.isEnabled() && loadNewPropertySources.booleanValue()) {
                this.addPropertySource(composite, configStore, applicationName, profiles, this.storeContextsMap, !configStoreIterator.hasNext());
                continue;
            }
            if (!configStore.isEnabled() && loadNewPropertySources.booleanValue()) {
                LOGGER.info("Not loading configurations from {} as it is not enabled.", (Object)configStore.getEndpoint());
                continue;
            }
            LOGGER.warn("Not loading configurations from {} as it failed on startup.", (Object)configStore.getEndpoint());
        }
        configloaded.set(true);
        startup.set(false);
        return composite;
    }

    public Map<String, List<String>> getStoreContextsMap() {
        return this.storeContextsMap;
    }

    private void addPropertySource(CompositePropertySource composite, ConfigStore store, String applicationName, List<String> profiles, Map<String, List<String>> storeContextsMap, boolean initFeatures) {
        ArrayList<String> contexts = new ArrayList<String>();
        contexts.addAll(this.generateContexts(this.properties.getDefaultContext(), store));
        contexts.addAll(this.generateContexts(applicationName, store));
        FeatureSet featureSet = new FeatureSet();
        ArrayList<AppConfigurationPropertySource> sourceList = new ArrayList<AppConfigurationPropertySource>();
        Collections.reverse(contexts);
        for (String sourceContext : contexts) {
            try {
                sourceList.addAll(this.create(sourceContext, store, storeContextsMap, profiles, initFeatures, featureSet));
                LOGGER.debug("PropertySource context [{}] is added.", (Object)sourceContext);
            }
            catch (Exception e) {
                if (store.isFailFast() || !startup.get()) {
                    LOGGER.error("Fail fast is set and there was an error reading configuration from Azure App Configuration store " + store.getEndpoint() + ". The configuration starting with " + sourceContext + " failed to load.");
                    ReflectionUtils.rethrowRuntimeException((Throwable)e);
                } else {
                    LOGGER.warn("Unable to load configuration from Azure AppConfiguration store " + store.getEndpoint() + ". The configurations starting with " + sourceContext + "failed to load.", (Throwable)e);
                    StateHolder.setLoadState(store.getEndpoint(), false);
                }
                return;
            }
        }
        sourceList.forEach(arg_0 -> ((CompositePropertySource)composite).addPropertySource(arg_0));
    }

    private List<String> generateContexts(String applicationName, ConfigStore configStore) {
        ArrayList<String> result = new ArrayList<String>();
        if (!StringUtils.hasText((String)applicationName)) {
            return result;
        }
        result.add(PATH_SPLITTER + applicationName + PATH_SPLITTER);
        return result;
    }

    private List<AppConfigurationPropertySource> create(String context, ConfigStore store, Map<String, List<String>> storeContextsMap, List<String> profiles, boolean initFeatures, FeatureSet featureSet) throws Exception {
        ArrayList<AppConfigurationPropertySource> sourceList = new ArrayList<AppConfigurationPropertySource>();
        try {
            List<AppConfigurationStoreSelects> selects = store.getSelects();
            for (AppConfigurationStoreSelects selectedKeys : selects) {
                this.putStoreContext(store.getEndpoint(), context, storeContextsMap);
                AppConfigurationPropertySource propertySource = new AppConfigurationPropertySource(context, store, selectedKeys, profiles, this.properties, this.clients, this.appProperties, this.keyVaultCredentialProvider, this.keyVaultClientProvider, this.keyVaultSecretProvider);
                propertySource.initProperties(featureSet);
                if (initFeatures) {
                    propertySource.initFeatures(featureSet);
                }
                sourceList.add(propertySource);
            }
            ArrayList<ConfigurationSetting> watchKeysSettings = new ArrayList<ConfigurationSetting>();
            ArrayList<ConfigurationSetting> watchKeysFeatures = new ArrayList<ConfigurationSetting>();
            for (AppConfigurationStoreTrigger trigger : store.getMonitoring().getTriggers()) {
                ConfigurationSetting watchKey2 = this.clients.getWatchKey(trigger.getKey(), trigger.getLabel(), store.getEndpoint());
                if (watchKey2 != null) {
                    watchKeysSettings.add(watchKey2);
                    continue;
                }
                watchKeysSettings.add(new ConfigurationSetting().setKey(trigger.getKey()).setLabel(trigger.getLabel()));
            }
            if (store.getFeatureFlags().getEnabled().booleanValue()) {
                SettingSelector settingSelector = new SettingSelector().setKeyFilter(store.getFeatureFlags().getKeyFilter()).setLabelFilter(store.getFeatureFlags().getLabelFilter());
                PagedIterable<ConfigurationSetting> watchKeys = this.clients.getFeatureFlagWatchKey(settingSelector, store.getEndpoint());
                watchKeys.forEach(watchKey -> watchKeysFeatures.add(NormalizeNull.normalizeNullLabel(watchKey)));
                StateHolder.setStateFeatureFlag(store.getEndpoint(), watchKeysFeatures, store.getMonitoring().getFeatureFlagRefreshInterval());
                StateHolder.setLoadStateFeatureFlag(store.getEndpoint(), true);
            }
            StateHolder.setState(store.getEndpoint(), watchKeysSettings, store.getMonitoring().getRefreshInterval());
            StateHolder.setLoadState(store.getEndpoint(), true);
        }
        catch (RuntimeException e) {
            this.delayException();
            throw e;
        }
        catch (Exception e) {
            this.delayException();
            throw e;
        }
        return sourceList;
    }

    private void putStoreContext(String storeName, String context, @NonNull Map<String, List<String>> storeContextsMap) {
        if (!StringUtils.hasText((String)context) || !StringUtils.hasText((String)storeName)) {
            return;
        }
        List<String> contexts = storeContextsMap.get(storeName);
        if (contexts == null) {
            contexts = new ArrayList<String>();
        }
        contexts.add(context);
        storeContextsMap.put(storeName, contexts);
    }

    private void delayException() {
        Date currentDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.appProperties.getStartDate());
        calendar.add(13, this.appProperties.getPrekillTime());
        Date maxRetryDate = calendar.getTime();
        if (currentDate.before(maxRetryDate)) {
            long diffInMillies = Math.abs(maxRetryDate.getTime() - currentDate.getTime());
            try {
                Thread.sleep(diffInMillies);
            }
            catch (InterruptedException e) {
                LOGGER.error("Failed to wait before fast fail.");
            }
        }
    }
}

