/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.spring.cloud.config.State;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class StateHolder {
    private static final int MAX_JITTER = 15;
    private static final String FEATURE_ENDPOINT = "_feature";
    private static final Map<String, State> STATE = new ConcurrentHashMap<String, State>();
    private static final Map<String, Boolean> LOAD_STATE = new ConcurrentHashMap<String, Boolean>();

    private StateHolder() {
        throw new IllegalStateException("Should not be callable.");
    }

    static State getState(String endpoint) {
        return STATE.get(endpoint);
    }

    static State getStateFeatureFlag(String endpoint) {
        return STATE.get(endpoint + FEATURE_ENDPOINT);
    }

    static void setState(String endpoint, List<ConfigurationSetting> watchKeys, Duration duration) {
        STATE.put(endpoint, new State(watchKeys, Math.toIntExact(duration.getSeconds()), endpoint));
    }

    static void setStateFeatureFlag(String endpoint, List<ConfigurationSetting> watchKeys, Duration duration) {
        StateHolder.setState(endpoint + FEATURE_ENDPOINT, watchKeys, duration);
    }

    static void setState(State state, Duration duration) {
        STATE.put(state.getKey(), new State(state.getWatchKeys(), Math.toIntExact(duration.getSeconds()), state.getKey()));
    }

    static void expireState(String endpoint) {
        long timeLeft;
        String key = endpoint;
        State oldState = STATE.get(key);
        SecureRandom random = new SecureRandom();
        long wait = (long)(random.nextDouble() * 15.0);
        if (wait < (timeLeft = (long)((int)((oldState.getNextRefreshCheck().getTime() - new Date().getTime()) / 1000L)))) {
            STATE.put(key, new State(oldState.getWatchKeys(), (int)wait, oldState.getKey()));
        }
    }

    static boolean getLoadState(String name) {
        return LOAD_STATE.getOrDefault(name, false);
    }

    static boolean getLoadStateFeatureFlag(String name) {
        return StateHolder.getLoadState(name + FEATURE_ENDPOINT);
    }

    static void setLoadState(String name, Boolean loaded) {
        LOAD_STATE.put(name, loaded);
    }

    static void setLoadStateFeatureFlag(String name, Boolean loaded) {
        StateHolder.setLoadState(name + FEATURE_ENDPOINT, loaded);
    }
}

