/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.pipline.policies;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.spring.cloud.config.HostType;
import com.azure.spring.cloud.config.RequestTracingConstants;
import com.azure.spring.cloud.config.RequestType;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public final class BaseAppConfigurationPolicy
implements HttpPipelinePolicy {
    private static final String PACKAGE_NAME = BaseAppConfigurationPolicy.class.getPackage().getImplementationTitle();
    public static final String USER_AGENT = String.format("%s/%s", StringUtils.replace((String)PACKAGE_NAME, (String)" ", (String)""), BaseAppConfigurationPolicy.class.getPackage().getImplementationVersion());
    static Boolean watchRequests = false;
    final boolean isDev;
    final boolean isKeyVaultConfigured;

    public BaseAppConfigurationPolicy(Boolean isDev, Boolean isKeyVaultConfigured) {
        this.isDev = isDev;
        this.isKeyVaultConfigured = isKeyVaultConfigured;
    }

    private String getTracingInfo(HttpRequest request) {
        String track = System.getenv(RequestTracingConstants.REQUEST_TRACING_DISABLED_ENVIRONMENT_VARIABLE.toString());
        if (track != null && track.equalsIgnoreCase("false")) {
            return "";
        }
        RequestType requestTypeValue = watchRequests != false ? RequestType.WATCH : RequestType.STARTUP;
        String tracingInfo = RequestTracingConstants.REQUEST_TYPE_KEY.toString() + "=" + (Object)((Object)requestTypeValue);
        String hostType = BaseAppConfigurationPolicy.getHostType();
        if (!hostType.isEmpty()) {
            tracingInfo = tracingInfo + "," + (Object)((Object)RequestTracingConstants.HOST_TYPE_KEY) + "=" + BaseAppConfigurationPolicy.getHostType();
        }
        if (this.isDev || this.isKeyVaultConfigured) {
            tracingInfo = tracingInfo + ",Env=" + this.getEnvInfo();
        }
        return tracingInfo;
    }

    private String getEnvInfo() {
        String envInfo = "";
        envInfo = this.buildEnvTracingInfo(envInfo, this.isDev, "Dev");
        envInfo = this.buildEnvTracingInfo(envInfo, this.isKeyVaultConfigured, "UsesKeyVault");
        return envInfo;
    }

    private String buildEnvTracingInfo(String envInfo, Boolean check, String checkString) {
        if (check.booleanValue()) {
            if (envInfo.length() > 0) {
                envInfo = envInfo + ",";
            }
            envInfo = envInfo + checkString;
        }
        return envInfo;
    }

    private static String getHostType() {
        HostType hostType = HostType.UNIDENTIFIED;
        if (System.getenv(RequestTracingConstants.AZURE_FUNCTIONS_ENVIRONMENT_VARIABLE.toString()) != null) {
            hostType = HostType.AZURE_FUNCTION;
        } else if (System.getenv(RequestTracingConstants.AZURE_WEB_APP_ENVIRONMENT_VARIABLE.toString()) != null) {
            hostType = HostType.AZURE_WEB_APP;
        } else if (System.getenv(RequestTracingConstants.KUBERNETES_ENVIRONMENT_VARIABLE.toString()) != null) {
            hostType = HostType.KUBERNETES;
        }
        return hostType.toString();
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        String sdkUserAgent = context.getHttpRequest().getHeaders().get("User-Agent").getValue();
        context.getHttpRequest().getHeaders().set("User-Agent", USER_AGENT + " " + sdkUserAgent);
        context.getHttpRequest().getHeaders().set(RequestTracingConstants.CORRELATION_CONTEXT_HEADER.toString(), this.getTracingInfo(context.getHttpRequest()));
        return next.process();
    }

    public static void setWatchRequests(Boolean watchRequests) {
        BaseAppConfigurationPolicy.watchRequests = watchRequests;
    }
}

