/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.properties;

import com.azure.spring.cloud.config.properties.AppConfigurationProviderProperties;
import com.azure.spring.cloud.config.properties.ConfigStore;
import com.azure.spring.cloud.config.resource.AppConfigManagedIdentityProperties;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotEmpty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Import;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="spring.cloud.azure.appconfiguration")
@Import(value={AppConfigurationProviderProperties.class})
public final class AppConfigurationProperties {
    public static final String CONFIG_PREFIX = "spring.cloud.azure.appconfiguration";
    public static final String LABEL_SEPARATOR = ",";
    private boolean enabled = true;
    private List<ConfigStore> stores = new ArrayList<ConfigStore>();
    @NotEmpty
    private String defaultContext = "application";
    private String name;
    @NestedConfigurationProperty
    private AppConfigManagedIdentityProperties managedIdentity;
    private boolean pushRefresh = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<ConfigStore> getStores() {
        return this.stores;
    }

    public void setStores(List<ConfigStore> stores) {
        this.stores = stores;
    }

    public String getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(String defaultContext) {
        this.defaultContext = defaultContext;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public AppConfigManagedIdentityProperties getManagedIdentity() {
        return this.managedIdentity;
    }

    public void setManagedIdentity(AppConfigManagedIdentityProperties managedIdentity) {
        this.managedIdentity = managedIdentity;
    }

    public Boolean getPushRefresh() {
        return this.pushRefresh;
    }

    public void setPushRefresh(Boolean pushRefresh) {
        this.pushRefresh = pushRefresh;
    }

    @PostConstruct
    public void validateAndInit() {
        Assert.notEmpty(this.stores, (String)"At least one config store has to be configured.");
        this.stores.forEach(store -> {
            Assert.isTrue((StringUtils.hasText((String)store.getEndpoint()) || StringUtils.hasText((String)store.getConnectionString()) ? 1 : 0) != 0, (String)"Either configuration store name or connection string should be configured.");
            store.validateAndInit();
        });
        int uniqueStoreSize = (int)this.stores.stream().map(ConfigStore::getEndpoint).distinct().count();
        Assert.isTrue((this.stores.size() == uniqueStoreSize ? 1 : 0) != 0, (String)"Duplicate store name exists.");
    }
}

