/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class AppConfigurationStoreSelects {
    private static final String[] EMPTY_LABEL_ARRAY = new String[]{"\u0000"};
    public static final String LABEL_SEPARATOR = ",";
    @NotNull
    private String keyFilter = "/application/";
    private String labelFilter;

    public String getKeyFilter() {
        return this.keyFilter;
    }

    public AppConfigurationStoreSelects setKeyFilter(String keyFilter) {
        this.keyFilter = keyFilter;
        return this;
    }

    public String[] getLabelFilter(List<String> profiles) {
        if (this.labelFilter == null && profiles.size() > 0) {
            Collections.reverse(profiles);
            return profiles.toArray(new String[profiles.size()]);
        }
        if (!StringUtils.hasText((String)this.labelFilter)) {
            return EMPTY_LABEL_ARRAY;
        }
        List<String> labels = Arrays.stream(this.labelFilter.split(LABEL_SEPARATOR)).map(label -> this.mapLabel((String)label)).distinct().collect(Collectors.toList());
        if (this.labelFilter.endsWith(LABEL_SEPARATOR)) {
            labels.add("\u0000");
        }
        Collections.reverse(labels);
        String[] t = new String[labels.size()];
        return labels.toArray(t);
    }

    public String getLabelFilterText(List<String> profiles) {
        return String.join((CharSequence)LABEL_SEPARATOR, this.getLabelFilter(profiles));
    }

    public String getLabel() {
        return this.labelFilter;
    }

    public AppConfigurationStoreSelects setLabelFilter(String labelFilter) {
        this.labelFilter = labelFilter;
        return this;
    }

    @PostConstruct
    public void validateAndInit() {
        Assert.isTrue((!this.keyFilter.contains("*") ? 1 : 0) != 0, (String)"KeyFilter must not contain asterisk(*)");
        if (this.labelFilter != null) {
            Assert.isTrue((!this.labelFilter.contains("*") ? 1 : 0) != 0, (String)"LabelFilter must not contain asterisk(*)");
        }
    }

    private String mapLabel(String label) {
        if (label == null || "".equals(label) || "\u0000".equals(label)) {
            return "\u0000";
        }
        return label.trim();
    }
}

