/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.health;

import com.azure.spring.cloud.config.AppConfigurationRefresh;
import com.azure.spring.cloud.config.health.AppConfigurationStoreHealth;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public final class AppConfigurationHealthIndicator
implements HealthIndicator {
    private final AppConfigurationRefresh refresh;

    public AppConfigurationHealthIndicator(AppConfigurationRefresh refresh) {
        this.refresh = refresh;
    }

    public Health health() {
        Health.Builder healthBuilder = new Health.Builder();
        boolean healthy = true;
        for (String store : this.refresh.getAppConfigurationStoresHealth().keySet()) {
            if (AppConfigurationStoreHealth.DOWN.equals((Object)this.refresh.getAppConfigurationStoresHealth().get(store))) {
                healthy = false;
                healthBuilder.withDetail(store, (Object)"DOWN");
                continue;
            }
            if (this.refresh.getAppConfigurationStoresHealth().get(store).equals((Object)AppConfigurationStoreHealth.NOT_LOADED)) {
                healthBuilder.withDetail(store, (Object)"NOT LOADED");
                continue;
            }
            healthBuilder.withDetail(store, (Object)"UP");
        }
        if (!healthy) {
            return healthBuilder.down().build();
        }
        return healthBuilder.up().build();
    }
}

