/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config;

import com.azure.core.http.rest.PagedIterable;
import com.azure.data.appconfiguration.ConfigurationClient;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.data.appconfiguration.models.SecretReferenceConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.spring.cloud.config.FeatureManagementMapper;
import com.azure.spring.cloud.config.JsonConfigurationParser;
import com.azure.spring.cloud.config.KeyVaultCredentialProvider;
import com.azure.spring.cloud.config.KeyVaultSecretProvider;
import com.azure.spring.cloud.config.SecretClientBuilderSetup;
import com.azure.spring.cloud.config.feature.management.entity.DynamicFeature;
import com.azure.spring.cloud.config.feature.management.entity.FeatureSet;
import com.azure.spring.cloud.config.properties.AppConfigurationProperties;
import com.azure.spring.cloud.config.properties.AppConfigurationProviderProperties;
import com.azure.spring.cloud.config.properties.AppConfigurationStoreSelects;
import com.azure.spring.cloud.config.properties.ConfigStore;
import com.azure.spring.cloud.config.stores.ClientStore;
import com.azure.spring.cloud.config.stores.KeyVaultClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public final class AppConfigurationPropertySource
extends EnumerablePropertySource<ConfigurationClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationPropertySource.class);
    private static final ObjectMapper FEATURE_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().propertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE)).build();
    private final AppConfigurationStoreSelects selectedKeys;
    private final List<String> profiles;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final AppConfigurationProperties appConfigurationProperties;
    private final HashMap<String, KeyVaultClient> keyVaultClients;
    private final ClientStore clients;
    private final KeyVaultCredentialProvider keyVaultCredentialProvider;
    private final SecretClientBuilderSetup keyVaultClientProvider;
    private final KeyVaultSecretProvider keyVaultSecretProvider;
    private final AppConfigurationProviderProperties appProperties;
    private final ConfigStore configStore;
    private final FeatureManagementMapper featureManagementMapper;

    AppConfigurationPropertySource(ConfigStore configStore, AppConfigurationStoreSelects selectedKeys, List<String> profiles, AppConfigurationProperties appConfigurationProperties, ClientStore clients, AppConfigurationProviderProperties appProperties, KeyVaultCredentialProvider keyVaultCredentialProvider, SecretClientBuilderSetup keyVaultClientProvider, KeyVaultSecretProvider keyVaultSecretProvider) {
        super(selectedKeys.getKeyFilter() + configStore.getEndpoint() + "/" + selectedKeys.getLabelFilterText(profiles));
        this.configStore = configStore;
        this.selectedKeys = selectedKeys;
        this.profiles = profiles;
        this.appConfigurationProperties = appConfigurationProperties;
        this.appProperties = appProperties;
        this.keyVaultClients = new HashMap();
        this.clients = clients;
        this.keyVaultCredentialProvider = keyVaultCredentialProvider;
        this.keyVaultClientProvider = keyVaultClientProvider;
        this.keyVaultSecretProvider = keyVaultSecretProvider;
        this.featureManagementMapper = new FeatureManagementMapper();
    }

    public String[] getPropertyNames() {
        Set<String> keySet = this.properties.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    void initProperties(FeatureSet featureSet) throws IOException {
        String storeName = this.configStore.getEndpoint();
        SettingSelector settingSelector = new SettingSelector();
        PagedIterable<ConfigurationSetting> features = null;
        if (this.configStore.getFeatureFlags().getEnabled().booleanValue()) {
            settingSelector.setKeyFilter(this.configStore.getFeatureFlags().getKeyFilter()).setLabelFilter(this.configStore.getFeatureFlags().getLabelFilter());
            features = this.clients.listSettings(settingSelector, storeName);
        }
        List<String> labels = Arrays.asList(this.selectedKeys.getLabelFilter(this.profiles));
        Collections.reverse(labels);
        for (String label : labels) {
            settingSelector = new SettingSelector().setKeyFilter(this.selectedKeys.getKeyFilter() + "*").setLabelFilter(label);
            PagedIterable<ConfigurationSetting> settings = this.clients.listSettings(settingSelector, storeName);
            for (ConfigurationSetting setting : settings) {
                String key = setting.getKey().trim().substring(this.selectedKeys.getKeyFilter().length()).replace('/', '.');
                if (setting instanceof SecretReferenceConfigurationSetting) {
                    String entry = this.getKeyVaultEntry((SecretReferenceConfigurationSetting)setting);
                    if (entry == null) continue;
                    this.properties.put(key, entry);
                    continue;
                }
                if (StringUtils.hasText((String)setting.getContentType()) && JsonConfigurationParser.isJsonContentType(setting.getContentType())) {
                    HashMap<String, Object> jsonSettings = JsonConfigurationParser.parseJsonSetting(setting);
                    for (Map.Entry<String, Object> jsonSetting : jsonSettings.entrySet()) {
                        key = jsonSetting.getKey().trim().substring(this.selectedKeys.getKeyFilter().length());
                        this.properties.put(key, jsonSetting.getValue());
                    }
                    continue;
                }
                this.properties.put(key, setting.getValue());
            }
        }
        this.addToFeatureSet(featureSet, features);
    }

    void initFeatures(FeatureSet featureSet) {
        this.properties.put(this.featureManagementMapper.getFeatureSchema(), FEATURE_MAPPER.convertValue(featureSet.getFeatureManagement(), LinkedHashMap.class));
    }

    private String getKeyVaultEntry(SecretReferenceConfigurationSetting secretReference) {
        String secretValue = null;
        try {
            KeyVaultSecret secret;
            URI uri = null;
            try {
                uri = new URI(secretReference.getSecretId());
            }
            catch (URISyntaxException e) {
                LOGGER.error("Error Processing Key Vault Entry URI.");
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
            if (!this.keyVaultClients.containsKey(uri.getHost())) {
                KeyVaultClient client = new KeyVaultClient(this.appConfigurationProperties, uri, this.keyVaultCredentialProvider, this.keyVaultClientProvider, this.keyVaultSecretProvider);
                this.keyVaultClients.put(uri.getHost(), client);
            }
            if ((secret = this.keyVaultClients.get(uri.getHost()).getSecret(uri, this.appProperties.getMaxRetryTime())) == null) {
                throw new IOException("No Key Vault Secret found for Reference.");
            }
            secretValue = secret.getValue();
        }
        catch (IOException | RuntimeException e) {
            LOGGER.error("Error Retrieving Key Vault Entry");
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
        return secretValue;
    }

    private FeatureSet addToFeatureSet(FeatureSet featureSet, PagedIterable<ConfigurationSetting> features) throws IOException {
        if (features == null) {
            return featureSet;
        }
        for (ConfigurationSetting setting : features) {
            if (setting instanceof FeatureFlagConfigurationSetting) {
                FeatureFlagConfigurationSetting featureSetting = (FeatureFlagConfigurationSetting)setting;
                Object feature = this.featureManagementMapper.createFeature(featureSetting);
                featureSet.addFeature(featureSetting.getFeatureId(), feature);
                continue;
            }
            if (!"application/vnd.microsoft.appconfig.df+json;charset=utf-8".equalsIgnoreCase(setting.getContentType()) || this.featureManagementMapper.getFeatureSchemaVersion() < 2) continue;
            DynamicFeature dynamicFeature = this.featureManagementMapper.createDynamicFeature(setting);
            this.properties.put("feature-management.dynamic-features." + dynamicFeature.getName(), FEATURE_MAPPER.convertValue((Object)dynamicFeature, LinkedHashMap.class));
        }
        return featureSet;
    }
}

