/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config;

import com.azure.core.http.rest.PagedIterable;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.spring.cloud.config.State;
import com.azure.spring.cloud.config.StateHolder;
import com.azure.spring.cloud.config.health.AppConfigurationStoreHealth;
import com.azure.spring.cloud.config.pipline.policies.BaseAppConfigurationPolicy;
import com.azure.spring.cloud.config.properties.AppConfigurationProperties;
import com.azure.spring.cloud.config.properties.AppConfigurationProviderProperties;
import com.azure.spring.cloud.config.properties.AppConfigurationStoreMonitoring;
import com.azure.spring.cloud.config.properties.ConfigStore;
import com.azure.spring.cloud.config.properties.FeatureFlagStore;
import com.azure.spring.cloud.config.stores.ClientStore;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;

@Component
public class AppConfigurationRefresh
implements ApplicationEventPublisherAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationRefresh.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final List<ConfigStore> configStores;
    private ApplicationEventPublisher publisher;
    private final AppConfigurationProviderProperties appProperties;
    private final ClientStore clientStore;
    private Map<String, AppConfigurationStoreHealth> clientHealth;
    private String eventDataInfo;
    private final Duration refreshInterval;

    public AppConfigurationRefresh(AppConfigurationProperties properties, AppConfigurationProviderProperties appProperties, ClientStore clientStore) {
        this.appProperties = appProperties;
        this.configStores = properties.getStores();
        this.refreshInterval = properties.getRefreshInterval();
        this.clientStore = clientStore;
        this.eventDataInfo = "";
        this.clientHealth = new HashMap<String, AppConfigurationStoreHealth>();
        this.configStores.forEach(store -> {
            if (this.getStoreHealthState((ConfigStore)store).booleanValue()) {
                this.clientHealth.put(store.getEndpoint(), AppConfigurationStoreHealth.UP);
            } else {
                this.clientHealth.put(store.getEndpoint(), AppConfigurationStoreHealth.NOT_LOADED);
            }
        });
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    @Async
    public Future<Boolean> refreshConfigurations() {
        return new AsyncResult((Object)this.refreshStores());
    }

    public void expireRefreshInterval(String endpoint, String syncToken) {
        for (ConfigStore configStore : this.configStores) {
            if (!configStore.getEndpoint().equals(endpoint)) continue;
            LOGGER.debug("Expiring refresh interval for " + configStore.getEndpoint());
            this.clientStore.updateSyncToken(endpoint, syncToken);
            StateHolder.expireState(configStore.getEndpoint());
            break;
        }
    }

    private boolean refreshStores() {
        boolean didRefresh = false;
        if (this.running.compareAndSet(false, true)) {
            BaseAppConfigurationPolicy.setWatchRequests(true);
            HashMap<String, AppConfigurationStoreHealth> clientHealthUpdate = new HashMap<String, AppConfigurationStoreHealth>();
            this.configStores.forEach(store -> {
                if (this.getStoreHealthState((ConfigStore)store).booleanValue()) {
                    clientHealthUpdate.put(store.getEndpoint(), AppConfigurationStoreHealth.DOWN);
                } else {
                    clientHealthUpdate.put(store.getEndpoint(), AppConfigurationStoreHealth.NOT_LOADED);
                }
            });
            try {
                if (this.refreshInterval != null && StateHolder.getNextForcedRefresh() != null && Instant.now().isAfter(StateHolder.getNextForcedRefresh())) {
                    this.eventDataInfo = "Minimum refresh period reached. Refreshing configurations.";
                    LOGGER.info(this.eventDataInfo);
                    RefreshEventData eventData = new RefreshEventData(this.eventDataInfo);
                    this.publisher.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, (Object)eventData, eventData.getMessage()));
                    this.running.set(false);
                    boolean bl = true;
                    return bl;
                }
                for (ConfigStore configStore : this.configStores) {
                    if (!configStore.isEnabled()) continue;
                    String endpoint = configStore.getEndpoint();
                    AppConfigurationStoreMonitoring monitor = configStore.getMonitoring();
                    if (StateHolder.getLoadState(endpoint)) {
                        if (monitor.isEnabled() && this.refresh(StateHolder.getState(endpoint), endpoint, monitor.getRefreshInterval())) {
                            didRefresh = true;
                            break;
                        }
                        LOGGER.debug("Skipping configuration refresh check for " + endpoint);
                        clientHealthUpdate.put(configStore.getEndpoint(), AppConfigurationStoreHealth.UP);
                    }
                    FeatureFlagStore featureStore = configStore.getFeatureFlags();
                    if (!StateHolder.getLoadStateFeatureFlag(endpoint)) continue;
                    if (featureStore.getEnabled().booleanValue() && this.refreshFeatureFlags(configStore, StateHolder.getStateFeatureFlag(endpoint), endpoint, monitor.getFeatureFlagRefreshInterval())) {
                        didRefresh = true;
                        break;
                    }
                    LOGGER.debug("Skipping feature flag refresh check for " + endpoint);
                    clientHealthUpdate.put(configStore.getEndpoint(), AppConfigurationStoreHealth.UP);
                }
            }
            catch (Exception e) {
                StateHolder.updateNextRefreshTime(this.refreshInterval, this.appProperties);
                throw e;
            }
            finally {
                this.running.set(false);
                this.clientHealth = clientHealthUpdate;
            }
        }
        return didRefresh;
    }

    private boolean refresh(State state, String endpoint, Duration refreshInterval) {
        Instant date = Instant.now();
        if (date.isAfter(state.getNextRefreshCheck())) {
            for (ConfigurationSetting watchKey : state.getWatchKeys()) {
                ConfigurationSetting watchedKey = this.clientStore.getWatchKey(watchKey.getKey(), watchKey.getLabel(), endpoint);
                String etag = null;
                if (watchedKey != null) {
                    etag = watchedKey.getETag();
                }
                LOGGER.debug(etag + " - " + watchKey.getETag());
                if (etag == null || etag.equals(watchKey.getETag())) continue;
                LOGGER.trace("Some keys in store [{}] matching the key [{}] and label [{}] is updated, will send refresh event.", new Object[]{endpoint, watchKey.getKey(), watchKey.getLabel()});
                this.eventDataInfo = watchKey.getKey();
                LOGGER.info("Configuration Refresh Event triggered by " + this.eventDataInfo);
                RefreshEventData eventData = new RefreshEventData(this.eventDataInfo);
                this.publisher.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, (Object)eventData, eventData.getMessage()));
                return true;
            }
            StateHolder.setState(state, refreshInterval);
        }
        return false;
    }

    private boolean refreshFeatureFlags(ConfigStore configStore, State state, String endpoint, Duration refreshInterval) {
        Instant date = Instant.now();
        if (date.isAfter(state.getNextRefreshCheck())) {
            SettingSelector selector = new SettingSelector().setKeyFilter(configStore.getFeatureFlags().getKeyFilter()).setLabelFilter(configStore.getFeatureFlags().getLabelFilter());
            PagedIterable<ConfigurationSetting> currentKeys = this.clientStore.getFeatureFlagWatchKey(selector, endpoint);
            int watchedKeySize = 0;
            block0: for (ConfigurationSetting currentKey : currentKeys) {
                ++watchedKeySize;
                for (ConfigurationSetting watchFlag : state.getWatchKeys()) {
                    String etag = null;
                    if (watchFlag == null) continue block0;
                    etag = watchFlag.getETag();
                    if (!watchFlag.getKey().equals(currentKey.getKey())) continue;
                    LOGGER.debug(etag + " - " + currentKey.getETag());
                    if (etag == null || etag.equals(currentKey.getETag())) continue block0;
                    LOGGER.trace("Some keys in store [{}] matching the key [{}] and label [{}] is updated, will send refresh event.", new Object[]{endpoint, watchFlag.getKey(), watchFlag.getLabel()});
                    this.eventDataInfo = watchFlag.getKey();
                    LOGGER.info("Configuration Refresh Event triggered by " + this.eventDataInfo);
                    RefreshEventData eventData = new RefreshEventData(this.eventDataInfo);
                    this.publisher.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, (Object)eventData, eventData.getMessage()));
                    return true;
                }
            }
            if (watchedKeySize != state.getWatchKeys().size()) {
                this.eventDataInfo = ".appconfig.featureflag/*";
                LOGGER.info("Configuration Refresh Event triggered by " + this.eventDataInfo);
                RefreshEventData eventData = new RefreshEventData(this.eventDataInfo);
                this.publisher.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, (Object)eventData, eventData.getMessage()));
                return true;
            }
            StateHolder.setState(state, refreshInterval);
        }
        return false;
    }

    public Map<String, AppConfigurationStoreHealth> getAppConfigurationStoresHealth() {
        return this.clientHealth;
    }

    private Boolean getStoreHealthState(ConfigStore store) {
        return store.isEnabled() && (StateHolder.getLoadState(store.getEndpoint()) || StateHolder.getLoadStateFeatureFlag(store.getEndpoint()));
    }

    static class RefreshEventData {
        private static final String MSG_TEMPLATE = "Some keys matching %s has been updated since last check.";
        private final String message;

        RefreshEventData(String prefix) {
            this.message = String.format(MSG_TEMPLATE, prefix);
        }

        public String getMessage() {
            return this.message;
        }
    }
}

