/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagFilter;
import com.azure.spring.cloud.config.AppConfigurationConstants;
import com.azure.spring.cloud.config.feature.management.entity.DynamicFeature;
import com.azure.spring.cloud.config.feature.management.entity.Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.util.StringUtils;

class FeatureManagementMapper {
    private static final String USERS = "users";
    private static final String USERS_CAPS = "Users";
    private static final String AUDIENCE = "Audience";
    private static final String GROUPS = "groups";
    private static final String GROUPS_CAPS = "Groups";
    private static final String TARGETING_FILTER = "targetingFilter";
    private static final String DEFAULT_ROLLOUT_PERCENTAGE = "defaultRolloutPercentage";
    private static final String DEFAULT_ROLLOUT_PERCENTAGE_CAPS = "DefaultRolloutPercentage";
    private static final ObjectMapper FEATURE_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().propertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE)).build();
    private static final ObjectMapper CASE_INSENSITIVE_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();

    FeatureManagementMapper() {
    }

    DynamicFeature createDynamicFeature(ConfigurationSetting item) throws JsonMappingException, JsonProcessingException {
        DynamicFeature dynamicFeature = (DynamicFeature)FEATURE_MAPPER.readValue(item.getValue(), DynamicFeature.class);
        dynamicFeature.getVariants().values().forEach(variant -> variant.setAssignmentParameters(this.convertTargeting(variant.getAssignmentParameters())));
        return dynamicFeature;
    }

    Object createFeature(FeatureFlagConfigurationSetting item) {
        String key = item.getFeatureId();
        Feature feature = new Feature(key, item);
        Map<Integer, FeatureFlagFilter> featureEnabledFor = feature.getEnabledFor();
        if (featureEnabledFor.size() == 0 && item.isEnabled()) {
            return true;
        }
        if (!item.isEnabled()) {
            return false;
        }
        feature.setEnabledFor(this.convertMap(featureEnabledFor));
        return feature;
    }

    int getFeatureSchemaVersion() {
        String version = System.getenv("AZURE_APP_CONFIGURATION_FEATURE_MANAGEMENT_SCHEMA_VERSION");
        switch (StringUtils.hasText((String)version) ? version : "") {
            case "1": {
                return AppConfigurationConstants.FEATURE_MANAGEMENT_V1_SCHEMA;
            }
            case "2": {
                return AppConfigurationConstants.FEATURE_MANAGEMENT_V2_SCHEMA;
            }
        }
        return AppConfigurationConstants.FEATURE_MANAGEMENT_V1_SCHEMA;
    }

    String getFeatureSchema() {
        int version = this.getFeatureSchemaVersion();
        if (version == AppConfigurationConstants.FEATURE_MANAGEMENT_V1_SCHEMA) {
            return "feature-management";
        }
        return "feature-management.feature-flags";
    }

    private Map<String, Object> convertTargeting(Map<String, Object> target) {
        Object audienceObject = target.get(AUDIENCE);
        if (audienceObject != null) {
            target = (Map)audienceObject;
        }
        List<Object> users = FeatureManagementMapper.convertToListOrEmptyList(target, USERS_CAPS);
        List<Object> groupRollouts = FeatureManagementMapper.convertToListOrEmptyList(target, GROUPS_CAPS);
        this.switchKeyValues(target, USERS_CAPS, USERS, this.mapValuesByIndex(users));
        this.switchKeyValues(target, GROUPS_CAPS, GROUPS, this.mapValuesByIndex(groupRollouts));
        this.switchKeyValues(target, DEFAULT_ROLLOUT_PERCENTAGE_CAPS, DEFAULT_ROLLOUT_PERCENTAGE, target.get(DEFAULT_ROLLOUT_PERCENTAGE_CAPS));
        return target;
    }

    private Map<String, Object> mapValuesByIndex(List<Object> users) {
        return IntStream.range(0, users.size()).boxed().collect(Collectors.toMap(String::valueOf, users::get));
    }

    private void switchKeyValues(Map<String, Object> parameters, String oldKey, String newKey, Object value) {
        parameters.put(newKey, value);
        parameters.remove(oldKey);
    }

    private Map<Integer, FeatureFlagFilter> convertMap(Map<Integer, FeatureFlagFilter> featureEnabledFor) {
        for (int filter = 0; filter < featureEnabledFor.size(); ++filter) {
            FeatureFlagFilter featureFilterEvaluationContext = featureEnabledFor.get(filter);
            Map parameters = featureFilterEvaluationContext.getParameters();
            if (parameters == null || !TARGETING_FILTER.equals(featureEnabledFor.get(filter).getName())) continue;
            featureFilterEvaluationContext.setParameters(this.convertTargeting(parameters));
            featureEnabledFor.put(filter, featureFilterEvaluationContext);
        }
        return featureEnabledFor;
    }

    private static List<Object> convertToListOrEmptyList(Map<String, Object> parameters, String key) {
        List listObjects = (List)CASE_INSENSITIVE_MAPPER.convertValue(parameters.get(key), (TypeReference)new TypeReference<List<Object>>(){});
        return listObjects == null ? Collections.emptyList() : listObjects;
    }
}

