/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.servicebus;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.servicebus.models.ServiceBusNamespace;
import com.azure.spring.cloud.autoconfigure.context.AzureContextAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.servicebus.AzureServiceBusProperties;
import com.azure.spring.cloud.context.core.config.AzureProperties;
import com.azure.spring.cloud.context.core.impl.ServiceBusNamespaceManager;
import com.azure.spring.cloud.telemetry.TelemetryCollector;
import com.azure.spring.integration.servicebus.factory.ServiceBusConnectionStringProvider;
import com.microsoft.azure.servicebus.IMessage;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureAfter(value={AzureContextAutoConfiguration.class})
@ConditionalOnClass(value={IMessage.class})
@ConditionalOnProperty(value={"spring.cloud.azure.servicebus.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={AzureServiceBusProperties.class})
public class AzureServiceBusAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureServiceBusAutoConfiguration.class);
    private static final String SERVICE_BUS = "ServiceBus";

    @PostConstruct
    public void collectTelemetry() {
        TelemetryCollector.getInstance().addService(SERVICE_BUS);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={AzureResourceManager.class, AzureProperties.class})
    public ServiceBusNamespaceManager serviceBusNamespaceManager(AzureResourceManager azureResourceManager, AzureProperties azureProperties) {
        return new ServiceBusNamespaceManager(azureResourceManager, azureProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceBusConnectionStringProvider serviceBusConnectionStringProvider(@Autowired(required=false) ServiceBusNamespaceManager namespaceManager, AzureServiceBusProperties properties) {
        String namespace = properties.getNamespace();
        String connectionString = properties.getConnectionString();
        if (StringUtils.hasText((String)connectionString)) {
            return new ServiceBusConnectionStringProvider(connectionString);
        }
        if (namespaceManager != null && namespace != null) {
            LOGGER.info("'spring.cloud.azure.servicebus.connection-string' auto configured");
            return new ServiceBusConnectionStringProvider((ServiceBusNamespace)namespaceManager.getOrCreate((Object)namespace));
        }
        LOGGER.warn("Can't construct the ServiceBusConnectionStringProvider, namespace: {}, connectionString: {}", (Object)namespace, (Object)connectionString);
        return null;
    }
}

