/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.cache;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.redis.models.RedisCache;
import com.azure.spring.cloud.autoconfigure.cache.AzureRedisProperties;
import com.azure.spring.cloud.autoconfigure.context.AzureContextAutoConfiguration;
import com.azure.spring.cloud.context.core.config.AzureProperties;
import com.azure.spring.cloud.context.core.impl.RedisCacheManager;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.core.RedisOperations;

@Configuration
@AutoConfigureAfter(value={AzureContextAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.azure.redis.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={RedisOperations.class})
@EnableConfigurationProperties(value={AzureRedisProperties.class})
public class AzureRedisAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public RedisCacheManager redisCacheManager(AzureResourceManager azureResourceManager, AzureProperties azureProperties) {
        return new RedisCacheManager(azureResourceManager, azureProperties);
    }

    @ConditionalOnMissingBean
    @Primary
    @Bean
    public RedisProperties redisProperties(AzureRedisProperties azureRedisProperties, RedisCacheManager redisCacheManager) {
        boolean isCluster;
        String cacheName = azureRedisProperties.getName();
        RedisCache redisCache = (RedisCache)redisCacheManager.getOrCreate((Object)cacheName);
        RedisProperties redisProperties = new RedisProperties();
        boolean useSsl = !redisCache.nonSslPort();
        int port = useSsl ? redisCache.sslPort() : redisCache.port();
        boolean bl = isCluster = redisCache.shardCount() > 0;
        if (isCluster) {
            RedisProperties.Cluster cluster = new RedisProperties.Cluster();
            cluster.setNodes(Arrays.asList(redisCache.hostname() + ":" + port));
            redisProperties.setCluster(cluster);
        } else {
            redisProperties.setHost(redisCache.hostname());
            redisProperties.setPort(port);
        }
        redisProperties.setPassword(redisCache.keys().primaryKey());
        redisProperties.setSsl(useSsl);
        return redisProperties;
    }
}

