/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.context.core.config;

import com.azure.spring.cloud.context.core.api.CredentialSupplier;
import com.azure.spring.cloud.context.core.enums.AzureEnvironments;
import com.google.common.base.Strings;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="spring.cloud.azure")
public class AzureProperties
implements CredentialSupplier {
    public static final String PREFIX = "spring.cloud.azure";
    private String clientId;
    private String clientSecret;
    private String tenantId;
    private String resourceGroup;
    private AzureEnvironments environment = AzureEnvironments.Azure;
    private String region;
    private boolean autoCreateResources = false;
    private boolean msiEnabled = false;
    private String subscriptionId;

    @PostConstruct
    private void validate() {
        if (this.autoCreateResources) {
            Assert.hasText((String)this.region, (String)"When auto create resources is enabled, spring.cloud.azure.region must be provided");
        }
        if (this.msiEnabled && Strings.isNullOrEmpty((String)this.subscriptionId)) {
            Assert.hasText((String)this.subscriptionId, (String)"When msi is enabled, spring.cloud.azure.subscription-id must be provided");
        }
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public void setResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    public AzureEnvironments getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(AzureEnvironments environment) {
        this.environment = environment;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public boolean isAutoCreateResources() {
        return this.autoCreateResources;
    }

    public void setAutoCreateResources(boolean autoCreateResources) {
        this.autoCreateResources = autoCreateResources;
    }

    @Override
    public boolean isMsiEnabled() {
        return this.msiEnabled;
    }

    public void setMsiEnabled(boolean msiEnabled) {
        this.msiEnabled = msiEnabled;
    }

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }
}

