/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.context.core.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.eventhubs.models.EventHubNamespace;
import com.azure.spring.cloud.context.core.config.AzureProperties;
import com.azure.spring.cloud.context.core.impl.AzureManager;

public class EventHubNamespaceManager
extends AzureManager<EventHubNamespace, String> {
    private final AzureResourceManager azureResourceManager;

    public EventHubNamespaceManager(AzureResourceManager azureResourceManager, AzureProperties azureProperties) {
        super(azureProperties);
        this.azureResourceManager = azureResourceManager;
    }

    @Override
    String getResourceName(String key) {
        return key;
    }

    @Override
    String getResourceType() {
        return EventHubNamespace.class.getSimpleName();
    }

    @Override
    public EventHubNamespace internalGet(String namespace) {
        try {
            return (EventHubNamespace)this.azureResourceManager.eventHubNamespaces().getByResourceGroup(this.resourceGroup, namespace);
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public EventHubNamespace internalCreate(String namespace) {
        return (EventHubNamespace)((EventHubNamespace.DefinitionStages.WithCreate)((EventHubNamespace.DefinitionStages.WithGroup)((EventHubNamespace.DefinitionStages.Blank)this.azureResourceManager.eventHubNamespaces().define(namespace)).withRegion(this.region)).withExistingResourceGroup(this.resourceGroup)).create();
    }
}

