/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.context.core.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.eventhubs.models.EventHub;
import com.azure.resourcemanager.eventhubs.models.EventHubNamespace;
import com.azure.spring.cloud.context.core.config.AzureProperties;
import com.azure.spring.cloud.context.core.impl.AzureManager;
import com.azure.spring.cloud.context.core.util.Tuple;

public class EventHubManager
extends AzureManager<EventHub, Tuple<EventHubNamespace, String>> {
    private final AzureResourceManager azureResourceManager;

    public EventHubManager(AzureResourceManager azureResourceManager, AzureProperties azureProperties) {
        super(azureProperties);
        this.azureResourceManager = azureResourceManager;
    }

    @Override
    String getResourceName(Tuple<EventHubNamespace, String> key) {
        return key.getSecond();
    }

    @Override
    String getResourceType() {
        return EventHub.class.getSimpleName();
    }

    @Override
    public EventHub internalGet(Tuple<EventHubNamespace, String> namespaceAndName) {
        try {
            return this.azureResourceManager.eventHubs().getByName(this.resourceGroup, namespaceAndName.getFirst().name(), namespaceAndName.getSecond());
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public EventHub internalCreate(Tuple<EventHubNamespace, String> namespaceAndName) {
        return (EventHub)((EventHub.DefinitionStages.Blank)this.azureResourceManager.eventHubs().define(namespaceAndName.getSecond())).withExistingNamespace(namespaceAndName.getFirst()).create();
    }
}

