/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.context.core.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.servicebus.models.ServiceBusSubscription;
import com.azure.resourcemanager.servicebus.models.Topic;
import com.azure.spring.cloud.context.core.config.AzureProperties;
import com.azure.spring.cloud.context.core.impl.AzureManager;
import com.azure.spring.cloud.context.core.util.Tuple;

public class ServiceBusTopicSubscriptionManager
extends AzureManager<ServiceBusSubscription, Tuple<Topic, String>> {
    public ServiceBusTopicSubscriptionManager(AzureProperties azureProperties) {
        super(azureProperties);
    }

    @Override
    String getResourceName(Tuple<Topic, String> key) {
        return key.getSecond();
    }

    @Override
    String getResourceType() {
        return ServiceBusSubscription.class.getSimpleName();
    }

    @Override
    public ServiceBusSubscription internalGet(Tuple<Topic, String> topicAndSubscriptionName) {
        try {
            return (ServiceBusSubscription)topicAndSubscriptionName.getFirst().subscriptions().getByName(topicAndSubscriptionName.getSecond());
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public ServiceBusSubscription internalCreate(Tuple<Topic, String> topicAndSubscriptionName) {
        return (ServiceBusSubscription)((ServiceBusSubscription.DefinitionStages.Blank)topicAndSubscriptionName.getFirst().subscriptions().define(topicAndSubscriptionName.getSecond())).create();
    }
}

