/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.config;

import com.azure.spring.messaging.config.AzureListenerEndpointRegistry;
import com.azure.spring.messaging.container.ListenerContainerFactory;
import com.azure.spring.messaging.endpoint.AzureListenerEndpoint;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.util.Assert;

public class AzureListenerEndpointRegistrar
implements BeanFactoryAware,
InitializingBean {
    private final List<AzureListenerEndpointDescriptor> endpointDescriptors;
    @Nullable
    private AzureListenerEndpointRegistry endpointRegistry;
    @Nullable
    private MessageHandlerMethodFactory messageHandlerMethodFactory;
    @Nullable
    private ListenerContainerFactory<?> containerFactory;
    @Nullable
    private String containerFactoryBeanName;
    @Nullable
    private BeanFactory beanFactory;
    private boolean startImmediately;
    private Object mutex;

    public AzureListenerEndpointRegistrar() {
        this.mutex = this.endpointDescriptors = new ArrayList<AzureListenerEndpointDescriptor>();
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.mutex = ((ConfigurableBeanFactory)beanFactory).getSingletonMutex();
        }
    }

    public void afterPropertiesSet() {
        this.registerAllEndpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerAllEndpoints() {
        Assert.state((this.endpointRegistry != null ? 1 : 0) != 0, (String)"No AzureListenerEndpointRegistry set");
        Object object = this.mutex;
        synchronized (object) {
            for (AzureListenerEndpointDescriptor descriptor : this.endpointDescriptors) {
                this.endpointRegistry.registerListenerContainer(descriptor.endpoint, this.resolveContainerFactory(descriptor));
            }
            this.startImmediately = true;
        }
    }

    private ListenerContainerFactory<?> resolveContainerFactory(AzureListenerEndpointDescriptor descriptor) {
        if (descriptor.containerFactory != null) {
            return descriptor.containerFactory;
        }
        if (this.containerFactory != null) {
            return this.containerFactory;
        }
        if (this.containerFactoryBeanName != null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
            this.containerFactory = (ListenerContainerFactory)this.beanFactory.getBean(this.containerFactoryBeanName, ListenerContainerFactory.class);
            return this.containerFactory;
        }
        throw new IllegalStateException("Could not resolve the " + ListenerContainerFactory.class.getSimpleName() + " to use for [" + descriptor.endpoint + "] no factory was given and no default is set.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEndpoint(AzureListenerEndpoint endpoint, @Nullable ListenerContainerFactory<?> factory) {
        Assert.notNull((Object)endpoint, (String)"Endpoint must not be null");
        Assert.hasText((String)endpoint.getId(), (String)"Endpoint id must be set");
        AzureListenerEndpointDescriptor descriptor = new AzureListenerEndpointDescriptor(endpoint, factory);
        Object object = this.mutex;
        synchronized (object) {
            if (this.startImmediately) {
                Assert.state((this.endpointRegistry != null ? 1 : 0) != 0, (String)"No AzureListenerEndpointRegistry set");
                this.endpointRegistry.registerListenerContainer(descriptor.endpoint, this.resolveContainerFactory(descriptor), true);
            } else {
                this.endpointDescriptors.add(descriptor);
            }
        }
    }

    public void registerEndpoint(AzureListenerEndpoint endpoint) {
        this.registerEndpoint(endpoint, null);
    }

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.containerFactoryBeanName = containerFactoryBeanName;
    }

    public AzureListenerEndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    public void setEndpointRegistry(AzureListenerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
        return this.messageHandlerMethodFactory;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    public void setContainerFactory(ListenerContainerFactory<?> containerFactory) {
        this.containerFactory = containerFactory;
    }

    private static class AzureListenerEndpointDescriptor {
        private final AzureListenerEndpoint endpoint;
        @Nullable
        private final ListenerContainerFactory<?> containerFactory;

        AzureListenerEndpointDescriptor(AzureListenerEndpoint endpoint, @Nullable ListenerContainerFactory<?> containerFactory) {
            this.endpoint = endpoint;
            this.containerFactory = containerFactory;
        }
    }
}

