/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.endpoint;

import com.azure.spring.messaging.container.MessageListenerContainer;
import com.azure.spring.messaging.endpoint.AbstractAzureListenerEndpoint;
import com.azure.spring.messaging.listener.AzureMessageHandler;
import com.azure.spring.messaging.listener.DefaultAzureMessageHandler;
import java.lang.reflect.Method;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.EmbeddedValueResolver;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringValueResolver;

public class MethodAzureListenerEndpoint
extends AbstractAzureListenerEndpoint
implements BeanFactoryAware {
    @Nullable
    private Object bean;
    @Nullable
    private Method method;
    @Nullable
    private MessageHandlerMethodFactory messageHandlerMethodFactory;
    @Nullable
    private StringValueResolver embeddedValueResolver;

    public void setBeanFactory(@Nullable BeanFactory beanFactory) {
        if (this.embeddedValueResolver == null && beanFactory instanceof ConfigurableBeanFactory) {
            this.embeddedValueResolver = new EmbeddedValueResolver((ConfigurableBeanFactory)beanFactory);
        }
    }

    @Override
    protected AzureMessageHandler createMessageHandler(MessageListenerContainer container) {
        Assert.state((this.messageHandlerMethodFactory != null ? 1 : 0) != 0, (String)"Could not create message listener - MessageHandlerMethodFactory not set");
        DefaultAzureMessageHandler messageListener = new DefaultAzureMessageHandler();
        InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(this.getBean(), this.getMethod());
        messageListener.setHandlerMethod(invocableHandlerMethod);
        return messageListener;
    }

    @Override
    protected StringBuilder getEndpointDescription() {
        return super.getEndpointDescription().append(" | bean='").append(this.bean).append("'").append(" | method='").append(this.method).append("'");
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }
}

