/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.eventhub.stream.binder;

import com.azure.spring.eventhub.stream.binder.properties.EventHubConsumerProperties;
import com.azure.spring.eventhub.stream.binder.properties.EventHubExtendedBindingProperties;
import com.azure.spring.eventhub.stream.binder.properties.EventHubProducerProperties;
import com.azure.spring.eventhub.stream.binder.provisioning.EventHubChannelProvisioner;
import com.azure.spring.integration.core.api.CheckpointConfig;
import com.azure.spring.integration.core.api.StartPosition;
import com.azure.spring.integration.core.api.SubscribeByGroupOperation;
import com.azure.spring.integration.core.api.reactor.DefaultMessageHandler;
import com.azure.spring.integration.core.api.reactor.SendOperation;
import com.azure.spring.integration.eventhub.api.EventHubOperation;
import com.azure.spring.integration.eventhub.inbound.EventHubInboundChannelAdapter;
import java.util.UUID;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.expression.Expression;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.StringUtils;

public class EventHubMessageChannelBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<EventHubConsumerProperties>, ExtendedProducerProperties<EventHubProducerProperties>, EventHubChannelProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, EventHubConsumerProperties, EventHubProducerProperties> {
    private final EventHubOperation eventHubOperation;
    private EventHubExtendedBindingProperties bindingProperties = new EventHubExtendedBindingProperties();

    public EventHubMessageChannelBinder(String[] headersToEmbed, EventHubChannelProvisioner provisioningProvider, EventHubOperation eventHubOperation) {
        super(headersToEmbed, (ProvisioningProvider)provisioningProvider);
        this.eventHubOperation = eventHubOperation;
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<EventHubProducerProperties> producerProperties, MessageChannel errorChannel) {
        DefaultMessageHandler handler = new DefaultMessageHandler(destination.getName(), (SendOperation)this.eventHubOperation);
        handler.setBeanFactory((BeanFactory)this.getBeanFactory());
        handler.setSync(((EventHubProducerProperties)producerProperties.getExtension()).isSync());
        handler.setSendTimeout(((EventHubProducerProperties)producerProperties.getExtension()).getSendTimeout());
        handler.setSendFailureChannel(errorChannel);
        if (producerProperties.isPartitioned()) {
            handler.setPartitionKeyExpressionString("'partitionKey-' + headers['scst_partition']");
        } else {
            handler.setPartitionKeyExpression((Expression)new FunctionExpression(m -> m.getPayload().hashCode()));
        }
        return handler;
    }

    protected MessageProducer createConsumerEndpoint(ConsumerDestination destination, String group, ExtendedConsumerProperties<EventHubConsumerProperties> properties) {
        boolean anonymous;
        this.eventHubOperation.setStartPosition(((EventHubConsumerProperties)properties.getExtension()).getStartPosition());
        CheckpointConfig checkpointConfig = CheckpointConfig.builder().checkpointMode(((EventHubConsumerProperties)properties.getExtension()).getCheckpointMode()).checkpointCount(((EventHubConsumerProperties)properties.getExtension()).getCheckpointCount()).checkpointInterval(((EventHubConsumerProperties)properties.getExtension()).getCheckpointInterval()).build();
        this.eventHubOperation.setCheckpointConfig(checkpointConfig);
        boolean bl = anonymous = !StringUtils.hasText((String)group);
        if (anonymous) {
            group = "anonymous." + UUID.randomUUID().toString();
            this.eventHubOperation.setStartPosition(StartPosition.LATEST);
        }
        EventHubInboundChannelAdapter inboundAdapter = new EventHubInboundChannelAdapter(destination.getName(), (SubscribeByGroupOperation)this.eventHubOperation, group);
        inboundAdapter.setBeanFactory((BeanFactory)this.getBeanFactory());
        AbstractMessageChannelBinder.ErrorInfrastructure errorInfrastructure = this.registerErrorInfrastructure(destination, group, (ConsumerProperties)properties);
        inboundAdapter.setErrorChannel((MessageChannel)errorInfrastructure.getErrorChannel());
        return inboundAdapter;
    }

    public EventHubConsumerProperties getExtendedConsumerProperties(String destination) {
        return this.bindingProperties.getExtendedConsumerProperties(destination);
    }

    public EventHubProducerProperties getExtendedProducerProperties(String destination) {
        return this.bindingProperties.getExtendedProducerProperties(destination);
    }

    public String getDefaultsPrefix() {
        return this.bindingProperties.getDefaultsPrefix();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return this.bindingProperties.getExtendedPropertiesEntryClass();
    }

    public void setBindingProperties(EventHubExtendedBindingProperties bindingProperties) {
        this.bindingProperties = bindingProperties;
    }
}

