/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.eventhub.converter;

import com.azure.messaging.eventhubs.EventData;
import com.azure.spring.integration.core.converter.AbstractAzureMessageConverter;
import java.nio.charset.Charset;
import java.util.Map;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.LinkedMultiValueMap;

public class EventHubMessageConverter
extends AbstractAzureMessageConverter<EventData> {
    protected byte[] getPayload(EventData azureMessage) {
        return azureMessage.getBody();
    }

    protected EventData fromString(String payload) {
        return new EventData(payload.getBytes(Charset.defaultCharset()));
    }

    protected EventData fromByte(byte[] payload) {
        return new EventData(payload);
    }

    protected void setCustomHeaders(MessageHeaders headers, EventData azureMessage) {
        super.setCustomHeaders(headers, (Object)azureMessage);
        headers.forEach((key, value) -> {
            if (key.equals("nativeHeaders") && value instanceof LinkedMultiValueMap) {
                azureMessage.getProperties().put(key, this.toJson(value));
            } else {
                azureMessage.getProperties().put(key, value.toString());
            }
        });
    }

    protected Map<String, Object> buildCustomHeaders(EventData azureMessage) {
        Map headers = super.buildCustomHeaders((Object)azureMessage);
        Map properties = azureMessage.getProperties();
        if (properties.containsKey("nativeHeaders") && this.isValidJson(properties.get("nativeHeaders"))) {
            String nativeHeader = (String)properties.remove("nativeHeaders");
            properties.put("nativeHeaders", this.readValue(nativeHeader, LinkedMultiValueMap.class));
        }
        headers.putAll(azureMessage.getProperties());
        return headers;
    }
}

