/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.eventhub.checkpoint;

import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.spring.integration.core.api.CheckpointConfig;
import com.azure.spring.integration.eventhub.checkpoint.BatchCheckpointManager;
import com.azure.spring.integration.eventhub.checkpoint.ManualCheckpointManager;
import com.azure.spring.integration.eventhub.checkpoint.PartitionCountCheckpointManager;
import com.azure.spring.integration.eventhub.checkpoint.RecordCheckpointManager;
import com.azure.spring.integration.eventhub.checkpoint.TimeCheckpointManager;
import com.azure.spring.integration.eventhub.util.EventDataHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CheckpointManager {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointManager.class);
    private static final String CHECKPOINT_FAIL_MSG = "Consumer group '%s' failed to checkpoint %s on partition %s";
    private static final String CHECKPOINT_SUCCESS_MSG = "Consumer group '%s' checkpointed %s on partition %s in %s mode";
    final CheckpointConfig checkpointConfig;

    CheckpointManager(CheckpointConfig checkpointConfig) {
        this.checkpointConfig = checkpointConfig;
    }

    public static CheckpointManager of(CheckpointConfig checkpointConfig) {
        switch (checkpointConfig.getCheckpointMode()) {
            case TIME: {
                return new TimeCheckpointManager(checkpointConfig);
            }
            case RECORD: {
                return new RecordCheckpointManager(checkpointConfig);
            }
            case BATCH: {
                return new BatchCheckpointManager(checkpointConfig);
            }
            case PARTITION_COUNT: {
                return new PartitionCountCheckpointManager(checkpointConfig);
            }
            case MANUAL: {
                return new ManualCheckpointManager(checkpointConfig);
            }
        }
        LOG.warn("Does not support checkpoint mode: " + checkpointConfig.getCheckpointMode().name());
        throw new IllegalArgumentException("Illegal checkpoint mode when building CheckpointManager");
    }

    public void onMessage(EventContext context, EventData eventData) {
    }

    public void completeBatch(EventContext context) {
    }

    void logCheckpointFail(EventContext context, EventData eventData, Throwable t) {
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn(String.format(CHECKPOINT_FAIL_MSG, context.getPartitionContext().getConsumerGroup(), EventDataHelper.toString(eventData), context.getPartitionContext().getPartitionId()), t);
        }
    }

    void logCheckpointSuccess(EventContext context, EventData eventData) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format(CHECKPOINT_SUCCESS_MSG, context.getPartitionContext().getConsumerGroup(), EventDataHelper.toString(eventData), context.getPartitionContext().getPartitionId(), this.checkpointConfig.getCheckpointMode()));
        }
    }

    abstract Logger getLogger();
}

