/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.eventhub.checkpoint;

import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.spring.integration.core.api.CheckpointConfig;
import com.azure.spring.integration.core.api.CheckpointMode;
import com.azure.spring.integration.eventhub.checkpoint.CheckpointManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class PartitionCountCheckpointManager
extends CheckpointManager {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionCountCheckpointManager.class);
    private final ConcurrentHashMap<String, AtomicInteger> countByPartition = new ConcurrentHashMap();

    PartitionCountCheckpointManager(CheckpointConfig checkpointConfig) {
        super(checkpointConfig);
        Assert.isTrue((this.checkpointConfig.getCheckpointMode() == CheckpointMode.PARTITION_COUNT ? 1 : 0) != 0, () -> "PartitionCountCheckpointManager should have checkpointMode partition_count");
    }

    @Override
    public void onMessage(EventContext context, EventData eventData) {
        String partitionId = context.getPartitionContext().getPartitionId();
        this.countByPartition.computeIfAbsent(partitionId, k -> new AtomicInteger(0));
        AtomicInteger count = this.countByPartition.get(partitionId);
        if (count.incrementAndGet() >= this.checkpointConfig.getCheckpointCount()) {
            context.updateCheckpointAsync().doOnError(t -> this.logCheckpointFail(context, eventData, (Throwable)t)).doOnSuccess(v -> {
                this.logCheckpointSuccess(context, eventData);
                count.set(0);
            }).subscribe();
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

