/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.eventhub.impl;

import com.azure.spring.cloud.context.core.util.Tuple;
import com.azure.spring.integration.eventhub.api.EventHubClientFactory;
import com.azure.spring.integration.eventhub.api.EventHubOperation;
import com.azure.spring.integration.eventhub.converter.EventHubMessageConverter;
import com.azure.spring.integration.eventhub.impl.AbstractEventHubTemplate;
import com.azure.spring.integration.eventhub.impl.EventHubProcessor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;

public class EventHubTemplate
extends AbstractEventHubTemplate
implements EventHubOperation {
    private static final Logger LOG = LoggerFactory.getLogger(EventHubTemplate.class);
    private final ConcurrentMap<Tuple<String, String>, Boolean> subscribedNameAndGroup = new ConcurrentHashMap<Tuple<String, String>, Boolean>();

    public EventHubTemplate(EventHubClientFactory clientFactory) {
        super(clientFactory);
        LOG.info("Started EventHubTemplate with properties: {}", this.buildPropertiesMap());
    }

    public boolean subscribe(String destination, String consumerGroup, Consumer<Message<?>> consumer, Class<?> messagePayloadType) {
        if (this.subscribedNameAndGroup.putIfAbsent((Tuple<String, String>)Tuple.of((Object)destination, (Object)consumerGroup), true) == null) {
            this.createEventProcessorClient(destination, consumerGroup, this.createEventProcessor(consumer, messagePayloadType));
            this.startEventProcessorClient(destination, consumerGroup);
            LOG.info("Consumer subscribed to destination '{}' with consumer group '{}'", (Object)destination, (Object)consumerGroup);
            return true;
        }
        return false;
    }

    public boolean unsubscribe(String destination, String consumerGroup) {
        if (this.subscribedNameAndGroup.remove(Tuple.of((Object)destination, (Object)consumerGroup), true)) {
            this.stopEventProcessorClient(destination, consumerGroup);
            LOG.info("Consumer unsubscribed from destination '{}' with consumer group '{}'", (Object)destination, (Object)consumerGroup);
            return true;
        }
        return false;
    }

    public EventHubProcessor createEventProcessor(Consumer<Message<?>> consumer, Class<?> messagePayloadType) {
        return new EventHubProcessor(consumer, messagePayloadType, this.getCheckpointConfig(), this.getMessageConverter());
    }

    @Override
    public EventHubMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    @Override
    public void setMessageConverter(EventHubMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }
}

