/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.eventhub.converter;

import com.azure.messaging.eventhubs.EventData;
import com.azure.spring.integration.core.converter.AbstractAzureMessageConverter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessageHeaders;

public class EventHubMessageConverter
extends AbstractAzureMessageConverter<EventData, EventData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventHubMessageConverter.class);

    protected Object getPayload(EventData azureMessage) {
        return azureMessage.getBody();
    }

    protected EventData fromString(String payload) {
        return new EventData(payload.getBytes(StandardCharsets.UTF_8));
    }

    protected EventData fromByte(byte[] payload) {
        return new EventData(payload);
    }

    protected void setCustomHeaders(MessageHeaders headers, EventData azureMessage) {
        super.setCustomHeaders(headers, (Object)azureMessage);
        headers.forEach((key, value) -> {
            if (SYSTEM_HEADERS.contains(key)) {
                LOGGER.warn("System property {}({}) is not allowed to be defined and will be ignored.", key, value);
            } else {
                azureMessage.getProperties().put(key, value.toString());
            }
        });
    }

    protected Map<String, Object> buildCustomHeaders(EventData azureMessage) {
        Map headers = super.buildCustomHeaders((Object)azureMessage);
        headers.putAll(this.getSystemProperties(azureMessage));
        headers.putAll(azureMessage.getProperties());
        return headers;
    }

    private Map<String, Object> getSystemProperties(EventData azureMessage) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(azureMessage.getSystemProperties());
        result.put("azure_eventhub_enqueued_time", azureMessage.getEnqueuedTime());
        result.put("azure_eventhub_offset", azureMessage.getOffset());
        result.put("azure_eventhub_sequence_number", azureMessage.getSequenceNumber());
        result.put("azure_partition_key", azureMessage.getPartitionKey());
        return result;
    }
}

