/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.eventhub.checkpoint;

import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.spring.integration.core.api.CheckpointConfig;
import com.azure.spring.integration.core.api.CheckpointMode;
import com.azure.spring.integration.eventhub.checkpoint.CheckpointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class RecordCheckpointManager
extends CheckpointManager {
    private static final Logger LOG = LoggerFactory.getLogger(RecordCheckpointManager.class);

    RecordCheckpointManager(CheckpointConfig checkpointConfig) {
        super(checkpointConfig);
        Assert.isTrue((this.checkpointConfig.getCheckpointMode() == CheckpointMode.RECORD ? 1 : 0) != 0, () -> "RecordCheckpointManager should have checkpointMode record");
    }

    @Override
    public void onMessage(EventContext context, EventData eventData) {
        context.updateCheckpointAsync().doOnError(t -> this.logCheckpointFail(context, eventData, (Throwable)t)).doOnSuccess(v -> this.logCheckpointSuccess(context, eventData)).subscribe();
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

