/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.eventhub.checkpoint;

import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.spring.integration.core.api.CheckpointConfig;
import com.azure.spring.integration.core.api.CheckpointMode;
import com.azure.spring.integration.eventhub.checkpoint.CheckpointManager;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class TimeCheckpointManager
extends CheckpointManager {
    private static final Logger LOG = LoggerFactory.getLogger(TimeCheckpointManager.class);
    private final AtomicReference<LocalDateTime> lastCheckpointTime = new AtomicReference<LocalDateTime>(LocalDateTime.now());

    TimeCheckpointManager(CheckpointConfig checkpointConfig) {
        super(checkpointConfig);
        Assert.isTrue((this.checkpointConfig.getCheckpointMode() == CheckpointMode.TIME ? 1 : 0) != 0, () -> "TimeCheckpointManager should have checkpointMode time");
    }

    @Override
    public void onMessage(EventContext context, EventData eventData) {
        LocalDateTime now = LocalDateTime.now();
        if (Duration.between(this.lastCheckpointTime.get(), now).compareTo(this.checkpointConfig.getCheckpointInterval()) > 0) {
            context.updateCheckpointAsync().doOnError(t -> this.logCheckpointFail(context, eventData, (Throwable)t)).doOnSuccess(v -> {
                this.logCheckpointSuccess(context, eventData);
                this.lastCheckpointTime.set(now);
            }).subscribe();
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

