/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.eventhub.converter;

import com.azure.messaging.eventhubs.EventData;
import com.azure.spring.integration.core.converter.AbstractAzureMessageConverter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.LinkedMultiValueMap;

public class EventHubMessageConverter
extends AbstractAzureMessageConverter<EventData, EventData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventHubMessageConverter.class);
    private static final Set<String> SYSTEM_HEADERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("azure_partition_key", "azure_eventhub_enqueued_time", "azure_eventhub_offset", "azure_eventhub_sequence_number")));

    protected byte[] getPayload(EventData azureMessage) {
        return azureMessage.getBody();
    }

    protected EventData fromString(String payload) {
        return new EventData(payload.getBytes(Charset.defaultCharset()));
    }

    protected EventData fromByte(byte[] payload) {
        return new EventData(payload);
    }

    protected void setCustomHeaders(MessageHeaders headers, EventData azureMessage) {
        super.setCustomHeaders(headers, (Object)azureMessage);
        headers.forEach((key, value) -> {
            if (key.equals("nativeHeaders") && value instanceof LinkedMultiValueMap) {
                azureMessage.getProperties().put(key, this.toJson(value));
            } else if (SYSTEM_HEADERS.contains(key)) {
                LOGGER.warn("System property {}({}) is not allowed to be defined and will be ignored.", key, value);
            } else {
                azureMessage.getProperties().put(key, value.toString());
            }
        });
    }

    protected Map<String, Object> buildCustomHeaders(EventData azureMessage) {
        Map headers = super.buildCustomHeaders((Object)azureMessage);
        headers.putAll(this.getSystemProperties(azureMessage));
        Map properties = azureMessage.getProperties();
        if (properties.containsKey("nativeHeaders") && this.isValidJson(properties.get("nativeHeaders"))) {
            String nativeHeader = (String)properties.remove("nativeHeaders");
            properties.put("nativeHeaders", this.readValue(nativeHeader, LinkedMultiValueMap.class));
        }
        headers.putAll(azureMessage.getProperties());
        return headers;
    }

    private Map<String, Object> getSystemProperties(EventData azureMessage) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("azure_eventhub_enqueued_time", azureMessage.getEnqueuedTime());
        result.put("azure_eventhub_offset", azureMessage.getOffset());
        result.put("azure_eventhub_sequence_number", azureMessage.getSequenceNumber());
        result.put("azure_partition_key", azureMessage.getPartitionKey());
        return result;
    }
}

