/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.eventhub.impl;

import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.models.CloseContext;
import com.azure.messaging.eventhubs.models.ErrorContext;
import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.messaging.eventhubs.models.EventPosition;
import com.azure.messaging.eventhubs.models.InitializationContext;
import com.azure.messaging.eventhubs.models.PartitionContext;
import com.azure.spring.integration.core.api.CheckpointConfig;
import com.azure.spring.integration.core.api.CheckpointMode;
import com.azure.spring.integration.core.api.reactor.AzureCheckpointer;
import com.azure.spring.integration.eventhub.checkpoint.CheckpointManager;
import com.azure.spring.integration.eventhub.converter.EventHubMessageConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public class EventHubProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventHubProcessor.class);
    protected final Consumer<Message<?>> consumer;
    protected final Class<?> payloadType;
    protected final CheckpointConfig checkpointConfig;
    protected final EventHubMessageConverter messageConverter;
    protected final CheckpointManager checkpointManager;
    protected EventPosition eventPosition = EventPosition.latest();

    public EventHubProcessor(Consumer<Message<?>> consumer, Class<?> payloadType, CheckpointConfig checkpointConfig, EventHubMessageConverter messageConverter) {
        this.consumer = consumer;
        this.payloadType = payloadType;
        this.checkpointConfig = checkpointConfig;
        this.messageConverter = messageConverter;
        this.checkpointManager = CheckpointManager.of(checkpointConfig);
    }

    public void onInitialize(InitializationContext context) {
        LOGGER.info("Started receiving on partition: {}", (Object)context.getPartitionContext().getPartitionId());
    }

    public void onClose(CloseContext context) {
        LOGGER.info("Stopped receiving on partition: {}. Reason: {}", (Object)context.getPartitionContext().getPartitionId(), (Object)context.getCloseReason());
    }

    public void onEvent(EventContext context) {
        PartitionContext partition = context.getPartitionContext();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("azure_raw_partition_id", partition.getPartitionId());
        EventData event = context.getEventData();
        AzureCheckpointer checkpointer = new AzureCheckpointer(() -> ((EventContext)context).updateCheckpointAsync());
        if (this.checkpointConfig.getCheckpointMode() == CheckpointMode.MANUAL) {
            headers.put("azure_checkpointer", (String)checkpointer);
        }
        this.consumer.accept(this.messageConverter.toMessage(event, (Map)new MessageHeaders(headers), this.payloadType));
        this.checkpointManager.onMessage(context, context.getEventData());
        if (this.checkpointConfig.getCheckpointMode() == CheckpointMode.BATCH) {
            this.checkpointManager.completeBatch(context);
        }
    }

    public void onError(ErrorContext context) {
        LOGGER.error("Error occurred on partition: {}. Error: {}", (Object)context.getPartitionContext().getPartitionId(), (Object)context.getThrowable());
    }

    public void setEventPosition(EventPosition eventPosition) {
        this.eventPosition = eventPosition;
    }
}

