/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.test.support;

import com.azure.spring.integration.core.AbstractInboundChannelAdapter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

public abstract class InboundChannelAdapterTest<A extends AbstractInboundChannelAdapter> {
    protected A adapter;
    protected String consumerGroup = "group";
    protected String destination = "dest";
    private String[] payloads = new String[]{"payload1", "payload2"};
    private List<Message<?>> messages = Arrays.stream(this.payloads).map(p -> MessageBuilder.withPayload((Object)p).build()).collect(Collectors.toList());

    @Test
    public void sendAndReceive() throws InterruptedException {
        DirectChannel channel = new DirectChannel();
        channel.setBeanName("output");
        this.adapter.doStart();
        this.adapter.setOutputChannel((MessageChannel)channel);
        CountDownLatch latch = new CountDownLatch(1);
        CopyOnWriteArrayList receivedMessages = new CopyOnWriteArrayList();
        channel.subscribe(message -> {
            try {
                receivedMessages.add((String)message.getPayload());
            }
            finally {
                latch.countDown();
            }
        });
        this.messages.forEach(arg_0 -> this.adapter.receiveMessage(arg_0));
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive message");
        for (int i = 0; i < receivedMessages.size(); ++i) {
            Assertions.assertEquals(receivedMessages.get(i), (Object)this.payloads[i]);
        }
    }

    @BeforeEach
    public abstract void setUp();

    public A getAdapter() {
        return this.adapter;
    }

    public void setAdapter(A adapter) {
        this.adapter = adapter;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }
}

