/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.test.support;

import com.azure.spring.integration.core.DefaultMessageHandler;
import com.azure.spring.integration.core.api.PartitionSupplier;
import com.azure.spring.integration.core.api.SendOperation;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.concurrent.ListenableFutureCallback;

public abstract class MessageHandlerTest<O extends SendOperation> {
    protected O sendOperation = null;
    protected DefaultMessageHandler handler = null;
    protected String destination = "dest";
    protected String dynamicDestination = "dynamicName";
    protected CompletableFuture<Void> future = new CompletableFuture();
    private Message<?> message = new GenericMessage((Object)"testPayload", (Map)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2"));
    private String payload = "payload";

    public abstract void setUp();

    protected O getSendOperation() {
        return this.sendOperation;
    }

    protected void setSendOperation(O sendOperation) {
        this.sendOperation = sendOperation;
    }

    protected DefaultMessageHandler getHandler() {
        return this.handler;
    }

    protected void setHandler(DefaultMessageHandler handler) {
        this.handler = handler;
    }

    protected String getDestination() {
        return this.destination;
    }

    protected void setDestination(String destination) {
        this.destination = destination;
    }

    protected String getDynamicDestination() {
        return this.dynamicDestination;
    }

    protected void setDynamicDestination(String dynamicDestination) {
        this.dynamicDestination = dynamicDestination;
    }

    protected CompletableFuture<Void> getFuture() {
        return this.future;
    }

    protected void setFuture(CompletableFuture<Void> future) {
        this.future = future;
    }

    @Test
    public void testSend() {
        this.handler.handleMessage(this.message);
        ((SendOperation)Mockito.verify(this.sendOperation, (VerificationMode)Mockito.times((int)1))).sendAsync((String)ArgumentMatchers.eq((Object)this.destination), (Message)ArgumentMatchers.isA(Message.class), (PartitionSupplier)ArgumentMatchers.isA(PartitionSupplier.class));
    }

    @Test
    public void testSendDynamicTopic() {
        GenericMessage dynamicMessage = new GenericMessage((Object)this.payload, (Map)ImmutableMap.of((Object)"azure_name", (Object)this.dynamicDestination));
        this.handler.handleMessage((Message)dynamicMessage);
        ((SendOperation)Mockito.verify(this.sendOperation, (VerificationMode)Mockito.times((int)1))).sendAsync((String)ArgumentMatchers.eq((Object)this.dynamicDestination), (Message)ArgumentMatchers.isA(Message.class), (PartitionSupplier)ArgumentMatchers.isA(PartitionSupplier.class));
    }

    @Test
    public void testSendSync() {
        this.handler.setSync(true);
        Expression timeout = (Expression)Mockito.spy((Object)this.handler.getSendTimeoutExpression());
        this.handler.setSendTimeoutExpression(timeout);
        this.handler.handleMessage(this.message);
        ((Expression)Mockito.verify((Object)timeout, (VerificationMode)Mockito.times((int)1))).getValue((EvaluationContext)ArgumentMatchers.eq(null), ArgumentMatchers.eq(this.message), (Class)ArgumentMatchers.eq(Long.class));
    }

    @Test
    public void testSendTimeout() {
        Mockito.when((Object)this.sendOperation.sendAsync((String)ArgumentMatchers.eq((Object)this.destination), (Message)ArgumentMatchers.isA(Message.class), (PartitionSupplier)ArgumentMatchers.isA(PartitionSupplier.class))).thenReturn(new CompletableFuture());
        this.handler.setSync(true);
        this.handler.setSendTimeout(1L);
        Assertions.assertThrows(MessageTimeoutException.class, () -> this.handler.handleMessage(this.message));
    }

    @Test
    public void testSendCallback() {
        ListenableFutureCallback callbackSpy = (ListenableFutureCallback)Mockito.spy((Object)new ListenableFutureCallback<Void>(){

            public void onFailure(Throwable ex) {
            }

            public void onSuccess(Void v) {
            }
        });
        this.handler.setSendCallback(callbackSpy);
        this.handler.handleMessage(this.message);
        ((ListenableFutureCallback)Mockito.verify((Object)callbackSpy, (VerificationMode)Mockito.times((int)1))).onSuccess((Object)((Void)ArgumentMatchers.eq(null)));
    }
}

