/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.test.support;

import com.azure.spring.integration.core.api.PartitionSupplier;
import com.azure.spring.integration.core.api.SendOperation;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.core.NestedRuntimeException;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.GenericMessage;
import reactor.core.publisher.Mono;

public abstract class SendOperationTest<O extends SendOperation> {
    protected String destination = "event-hub";
    protected Message<?> message = new GenericMessage((Object)"testPayload", (Map)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2"));
    protected Mono<Void> mono = Mono.empty();
    protected String partitionKey = "key";
    protected String payload = "payload";
    protected O sendOperation = null;
    private String partitionId = "1";

    protected abstract void setupError(String var1);

    @Test
    public void testSendCreateSenderFailure() throws Throwable {
        this.whenSendWithException();
        Assertions.assertThrows(NestedRuntimeException.class, () -> this.sendOperation.sendAsync(this.destination, this.message, null).get());
    }

    @Test
    public void testSendFailure() {
        this.setupError("future failed.");
        CompletableFuture future = this.sendOperation.sendAsync(this.destination, this.message, null);
        try {
            future.get();
            Fail.fail((String)"Test should fail.");
        }
        catch (InterruptedException ie) {
            Fail.fail((String)"get() should fail with an ExecutionException.");
        }
        catch (ExecutionException ee) {
            Assertions.assertEquals((Object)"future failed.", (Object)ee.getCause().getMessage());
        }
    }

    @Test
    public void testSendWithPartitionId() throws ExecutionException, InterruptedException {
        PartitionSupplier partitionSupplier = new PartitionSupplier();
        partitionSupplier.setPartitionId(this.partitionId);
        CompletableFuture future = this.sendOperation.sendAsync(this.destination, this.message, partitionSupplier);
        Assertions.assertNull(future.get());
        this.verifySendWithPartitionId(1);
        this.verifyPartitionSenderCalled(1);
    }

    @Test
    public void testSendWithPartitionKey() throws ExecutionException, InterruptedException {
        PartitionSupplier partitionSupplier = new PartitionSupplier();
        partitionSupplier.setPartitionKey(this.partitionKey);
        CompletableFuture future = this.sendOperation.sendAsync(this.destination, this.message, partitionSupplier);
        Assertions.assertNull(future.get());
        this.verifySendWithPartitionKey(1);
        this.verifyGetClientCreator(1);
    }

    @Test
    public void testSendWithoutPartition() throws ExecutionException, InterruptedException {
        CompletableFuture future = this.sendOperation.sendAsync(this.destination, this.message, new PartitionSupplier());
        Assertions.assertNull(future.get());
        this.verifySendCalled(1);
    }

    @Test
    public void testSendWithoutPartitionSupplier() throws ExecutionException, InterruptedException {
        CompletableFuture future = this.sendOperation.sendAsync(this.destination, this.message, null);
        Assertions.assertNull(future.get());
        this.verifySendCalled(1);
    }

    protected abstract void verifyGetClientCreator(int var1);

    protected abstract void verifyPartitionSenderCalled(int var1);

    protected abstract void verifySendCalled(int var1);

    protected abstract void verifySendWithPartitionId(int var1);

    protected abstract void verifySendWithPartitionKey(int var1);

    protected abstract void whenSendWithException();

    public Mono<Void> getMono() {
        return this.mono;
    }

    public void setMono(Mono<Void> mono) {
        this.mono = mono;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public O getSendOperation() {
        return this.sendOperation;
    }

    public void setSendOperation(O sendOperation) {
        this.sendOperation = sendOperation;
    }
}

