/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.test.support;

import com.azure.spring.integration.core.api.SubscribeByGroupOperation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.messaging.Message;

public abstract class SubscribeByGroupOperationTest<O extends SubscribeByGroupOperation> {
    protected O subscribeByGroupOperation;
    protected String consumerGroup = "consumer-group";
    protected String anotherConsumerGroup = "consumer-group2";
    protected String destination = "event-hub";

    @Test
    public void testSubscribeAndUnsubscribe() {
        boolean succeed = this.subscribeByGroupOperation.subscribe(this.destination, this.consumerGroup, this::handleMessage);
        Assertions.assertTrue((boolean)succeed);
        this.verifySubscriberCreatorCalled();
        this.verifySubscriberRegistered(1);
        boolean unsubscribed = this.subscribeByGroupOperation.unsubscribe(this.destination, this.consumerGroup);
        Assertions.assertTrue((boolean)unsubscribed);
        this.verifySubscriberUnregistered(1);
    }

    @Test
    public void testSubscribeTwice() {
        boolean onceSucceed = this.subscribeByGroupOperation.subscribe(this.destination, this.consumerGroup, this::handleMessage);
        Assertions.assertTrue((boolean)onceSucceed);
        this.verifySubscriberRegistered(1);
        boolean twiceSucceed = this.subscribeByGroupOperation.subscribe(this.destination, this.consumerGroup, this::handleMessage);
        Assertions.assertFalse((boolean)twiceSucceed);
        this.verifySubscriberCreatorCalled();
        this.verifySubscriberRegistered(1);
        this.verifySubscriberUnregistered(0);
    }

    @Test
    public void testSubscribeWithAnotherGroup() {
        boolean onceSucceed = this.subscribeByGroupOperation.subscribe(this.destination, this.consumerGroup, this::handleMessage);
        Assertions.assertTrue((boolean)onceSucceed);
        this.verifySubscriberRegistered(1);
        boolean twiceSucceed = this.subscribeByGroupOperation.subscribe(this.destination, this.anotherConsumerGroup, this::handleMessage);
        Assertions.assertTrue((boolean)twiceSucceed);
        this.verifySubscriberCreatorCalled();
        this.verifySubscriberUnregistered(0);
    }

    @Test
    public void testUnsubscribeNotSubscribed() {
        boolean unsubscribed = this.subscribeByGroupOperation.unsubscribe(this.destination, this.consumerGroup);
        Assertions.assertFalse((boolean)unsubscribed);
        this.verifySubscriberCreatorNotCalled();
        this.verifySubscriberUnregistered(0);
    }

    private void handleMessage(Message<?> message) {
    }

    protected abstract void verifySubscriberCreatorCalled();

    protected abstract void verifySubscriberCreatorNotCalled();

    protected abstract void verifySubscriberRegistered(int var1);

    protected abstract void verifySubscriberUnregistered(int var1);

    public O getSubscribeByGroupOperation() {
        return this.subscribeByGroupOperation;
    }

    public void setSubscribeByGroupOperation(O subscribeByGroupOperation) {
        this.subscribeByGroupOperation = subscribeByGroupOperation;
    }
}

