/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.test.support;

import com.azure.spring.integration.core.api.SubscribeOperation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.messaging.Message;

public abstract class SubscribeOperationTest<O extends SubscribeOperation> {
    protected O subscribeOperation;
    protected String destination = "event-hub";

    @Test
    public void testSubscribeAndUnsubscribe() {
        boolean succeed = this.subscribeOperation.subscribe(this.destination, this::handleMessage);
        Assertions.assertTrue((boolean)succeed);
        this.verifySubscriberCreatorCalled();
        this.verifySubscriberRegistered(1);
        boolean unsubscribed = this.subscribeOperation.unsubscribe(this.destination);
        Assertions.assertTrue((boolean)unsubscribed);
        this.verifySubscriberUnregistered(1);
    }

    @Test
    public void testSubscribeTwice() {
        boolean onceSucceed = this.subscribeOperation.subscribe(this.destination, this::handleMessage);
        Assertions.assertTrue((boolean)onceSucceed);
        this.verifySubscriberRegistered(1);
        boolean twiceSucceed = this.subscribeOperation.subscribe(this.destination, this::handleMessage);
        Assertions.assertFalse((boolean)twiceSucceed);
        this.verifySubscriberCreatorCalled();
        this.verifySubscriberRegistered(1);
        this.verifySubscriberUnregistered(0);
    }

    @Test
    public void testUnsubscribeNotSubscribed() {
        boolean unsubscribed = this.subscribeOperation.unsubscribe(this.destination);
        Assertions.assertFalse((boolean)unsubscribed);
        this.verifySubscriberCreatorNotCalled();
        this.verifySubscriberUnregistered(0);
    }

    private void handleMessage(Message<?> message) {
    }

    protected abstract void verifySubscriberCreatorCalled();

    protected abstract void verifySubscriberCreatorNotCalled();

    protected abstract void verifySubscriberRegistered(int var1);

    protected abstract void verifySubscriberUnregistered(int var1);

    public O getSubscribeOperation() {
        return this.subscribeOperation;
    }

    public void setSubscribeOperation(O subscribeOperation) {
        this.subscribeOperation = subscribeOperation;
    }
}

