/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.test.support;

import com.azure.spring.integration.core.converter.AzureMessageConverter;
import com.azure.spring.integration.test.support.pojo.User;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;

public abstract class UnaryAzureMessageConverterTest<T> {
    protected String headerProperties = "headerProperties";
    protected String payload = "payload";
    private AzureMessageConverter<T, T> converter = null;

    protected abstract AzureMessageConverter<T, T> getConverter();

    protected abstract Class<T> getTargetClass();

    protected abstract void assertMessageHeadersEqual(T var1, Message<?> var2);

    @BeforeEach
    public void setUp() {
        this.converter = this.getConverter();
    }

    @Test
    public void payloadAsByte() {
        this.convertAndBack(this.payload.getBytes(StandardCharsets.UTF_8), byte[].class);
    }

    @Test
    public void payloadAsString() {
        this.convertAndBack(this.payload, String.class);
    }

    @Test
    public void payloadAsUserClass() {
        this.convertAndBack(new User(this.payload), User.class);
    }

    private <U> void convertAndBack(U payload, Class<U> payloadClass) {
        Message message = MessageBuilder.withPayload(payload).setHeader(this.headerProperties, (Object)this.headerProperties).build();
        Object azureMessage = this.converter.fromMessage(message, this.getTargetClass());
        Message convertedMessage = this.converter.toMessage(azureMessage, payloadClass);
        Assertions.assertNotNull((Object)convertedMessage);
        this.assertMessagePayloadEquals(convertedMessage.getPayload(), payload);
        this.assertMessageHeadersEqual(azureMessage, convertedMessage);
    }

    private <U> void assertMessagePayloadEquals(U convertedPayload, U payload) {
        if (convertedPayload.getClass().equals(byte[].class)) {
            Assertions.assertArrayEquals((byte[])((byte[])convertedPayload), (byte[])((byte[])payload));
        } else {
            Assertions.assertEquals(convertedPayload, payload);
        }
    }
}

