/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.test.support.reactor;

import com.azure.spring.integration.core.api.PartitionSupplier;
import com.azure.spring.integration.core.api.reactor.DefaultMessageHandler;
import com.azure.spring.integration.core.api.reactor.SendOperation;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.reactivestreams.Publisher;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.concurrent.ListenableFutureCallback;
import reactor.core.publisher.Mono;

public abstract class MessageHandlerTest<O extends SendOperation> {
    protected String destination = "dest";
    protected String dynamicDestination = "dynamicName";
    protected DefaultMessageHandler handler;
    protected Mono<Void> mono = Mono.empty();
    protected O sendOperation;
    private Message<?> message = new GenericMessage((Object)"testPayload", (Map)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2"));
    private String payload = "payload";

    public abstract void setUp();

    @Test
    public void testSend() {
        this.handler.handleMessage(this.message);
        ((SendOperation)Mockito.verify(this.sendOperation, (VerificationMode)Mockito.times((int)1))).sendAsync((String)ArgumentMatchers.eq((Object)this.destination), (Message)ArgumentMatchers.isA(Message.class), (PartitionSupplier)ArgumentMatchers.isA(PartitionSupplier.class));
    }

    @Test
    public void testSendCallback() {
        ListenableFutureCallback callbackSpy = (ListenableFutureCallback)Mockito.spy((Object)new ListenableFutureCallback<Void>(){

            public void onFailure(Throwable ex) {
            }

            public void onSuccess(Void v) {
            }
        });
        this.handler.setSendCallback(callbackSpy);
        this.handler.handleMessage(this.message);
        ((ListenableFutureCallback)Mockito.verify((Object)callbackSpy, (VerificationMode)Mockito.times((int)1))).onSuccess((Object)((Void)ArgumentMatchers.eq(null)));
    }

    @Test
    public void testSendDynamicTopic() {
        GenericMessage dynamicMessage = new GenericMessage((Object)this.payload, (Map)ImmutableMap.of((Object)"azure_name", (Object)this.dynamicDestination));
        this.handler.handleMessage((Message)dynamicMessage);
        ((SendOperation)Mockito.verify(this.sendOperation, (VerificationMode)Mockito.times((int)1))).sendAsync((String)ArgumentMatchers.eq((Object)this.dynamicDestination), (Message)ArgumentMatchers.isA(Message.class), (PartitionSupplier)ArgumentMatchers.isA(PartitionSupplier.class));
    }

    @Test
    public void testSendSync() {
        this.handler.setSync(true);
        Expression timeout = (Expression)Mockito.spy((Object)this.handler.getSendTimeoutExpression());
        this.handler.setSendTimeoutExpression(timeout);
        this.handler.handleMessage(this.message);
        ((Expression)Mockito.verify((Object)timeout, (VerificationMode)Mockito.times((int)1))).getValue((EvaluationContext)ArgumentMatchers.eq(null), ArgumentMatchers.eq(this.message), (Class)ArgumentMatchers.eq(Long.class));
    }

    @Test
    public void testSendTimeout() {
        Mockito.when((Object)this.sendOperation.sendAsync((String)ArgumentMatchers.eq((Object)this.destination), (Message)ArgumentMatchers.isA(Message.class), (PartitionSupplier)ArgumentMatchers.isA(PartitionSupplier.class))).thenReturn((Object)Mono.empty().timeout((Publisher)Mono.empty()));
        this.handler.setSync(true);
        this.handler.setSendTimeout(1L);
        Assertions.assertThrows(MessageTimeoutException.class, () -> this.handler.handleMessage(this.message));
    }

    public Mono<Void> getMono() {
        return this.mono;
    }

    public void setMono(Mono<Void> mono) {
        this.mono = mono;
    }

    public DefaultMessageHandler getHandler() {
        return this.handler;
    }

    public void setHandler(DefaultMessageHandler handler) {
        this.handler = handler;
    }

    public O getSendOperation() {
        return this.sendOperation;
    }

    public void setSendOperation(O sendOperation) {
        this.sendOperation = sendOperation;
    }
}

