/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.test.support.reactor;

import com.azure.spring.integration.core.api.reactor.SendOperation;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.core.NestedRuntimeException;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.GenericMessage;
import reactor.core.publisher.Mono;

public abstract class SendOperationTest<O extends SendOperation> {
    protected String consumerGroup = "consumer-group";
    protected String destination = "event-hub";
    protected Message<?> message = new GenericMessage((Object)"testPayload", (Map)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2"));
    protected Mono<Void> mono = Mono.empty();
    protected String payload = "payload";
    protected O sendOperation;

    protected abstract void setupError(String var1);

    @Test
    public void testSend() {
        Mono mono = this.sendOperation.sendAsync(this.destination, this.message, null);
        Assertions.assertNull((Object)mono.block());
        this.verifySendCalled(1);
    }

    @Test
    public void testSendCreateSenderFailure() {
        this.whenSendWithException();
        Assertions.assertThrows(NestedRuntimeException.class, () -> this.sendOperation.sendAsync(this.destination, this.message, null).block());
    }

    @Test
    public void testSendFailure() {
        String errorMessage = "Send failed.";
        this.setupError(errorMessage);
        Mono mono = this.sendOperation.sendAsync(this.destination, this.message, null);
        try {
            mono.block();
            Fail.fail((String)"Test should fail.");
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)errorMessage, (Object)e.getMessage());
        }
    }

    protected abstract void verifyGetClientCreator(int var1);

    protected abstract void verifySendCalled(int var1);

    protected abstract void whenSendWithException();

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public Mono<Void> getMono() {
        return this.mono;
    }

    public void setMono(Mono<Void> mono) {
        this.mono = mono;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public O getSendOperation() {
        return this.sendOperation;
    }

    public void setSendOperation(O sendOperation) {
        this.sendOperation = sendOperation;
    }
}

