/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.actuator.autoconfigure.implementation.cosmos;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.spring.cloud.actuator.implementation.cosmos.CosmosHealthIndicator;
import com.azure.spring.cloud.autoconfigure.implementation.cosmos.AzureCosmosAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.cosmos.properties.AzureCosmosProperties;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={CosmosAsyncClient.class, HealthIndicator.class})
@ConditionalOnBean(value={CosmosAsyncClient.class})
@AutoConfigureAfter(value={AzureCosmosAutoConfiguration.class})
@ConditionalOnEnabledHealthIndicator(value="azure-cosmos")
public class CosmosHealthConfiguration {
    @Bean
    HealthIndicator cosmosHealthContributor(AzureCosmosProperties azureCosmosProperties, CosmosAsyncClient cosmosAsyncClient) {
        return new CosmosHealthIndicator(cosmosAsyncClient, azureCosmosProperties.getDatabase(), azureCosmosProperties.getEndpoint());
    }
}

