/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.actuator.implementation.eventhubs;

import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.spring.cloud.actuator.implementation.util.ActuateConstants;
import java.time.Duration;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class EventHubsHealthIndicator
extends AbstractHealthIndicator {
    private final EventHubProducerAsyncClient producerAsyncClient;
    private final EventHubConsumerAsyncClient consumerAsyncClient;
    private Duration timeout = ActuateConstants.DEFAULT_HEALTH_CHECK_TIMEOUT;

    public EventHubsHealthIndicator(EventHubProducerAsyncClient producerAsyncClient, EventHubConsumerAsyncClient consumerAsyncClient) {
        this.producerAsyncClient = producerAsyncClient;
        this.consumerAsyncClient = consumerAsyncClient;
    }

    protected void doHealthCheck(Health.Builder builder) {
        if (this.producerAsyncClient == null && this.consumerAsyncClient == null) {
            builder.withDetail("No client configured", (Object)"No Event Hub producer or consumer clients found.");
            return;
        }
        if (this.producerAsyncClient != null) {
            this.producerAsyncClient.getEventHubProperties().map(p -> builder.up()).block(this.timeout);
        } else {
            this.consumerAsyncClient.getEventHubProperties().map(p -> builder.up()).block(this.timeout);
        }
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }
}

