/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.actuator.implementation.keyvault;

import com.azure.core.exception.ResourceNotFoundException;
import com.azure.security.keyvault.certificates.CertificateAsyncClient;
import com.azure.spring.cloud.actuator.implementation.util.ActuateConstants;
import java.time.Duration;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class KeyVaultCertificateHealthIndicator
extends AbstractHealthIndicator {
    private final CertificateAsyncClient certificateAsyncClient;
    private Duration timeout = ActuateConstants.DEFAULT_HEALTH_CHECK_TIMEOUT;

    public KeyVaultCertificateHealthIndicator(CertificateAsyncClient certificateAsyncClient) {
        this.certificateAsyncClient = certificateAsyncClient;
    }

    protected void doHealthCheck(Health.Builder builder) {
        try {
            this.certificateAsyncClient.getCertificateWithResponse("spring-cloud-azure-not-existing-certificate").block(this.timeout);
            builder.up();
        }
        catch (ResourceNotFoundException e) {
            builder.up();
        }
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }
}

