/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.web.implementation;

import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationStoreMonitoring;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.ConfigStore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public class AppConfigurationEndpoint {
    private static final String CONFIG_STORE_TOPIC = "configurationstores";
    private final String endpoint;
    private final String store;
    private final List<ConfigStore> configStores;
    private final Map<String, String> allRequestParams;
    private final String syncToken;
    private final JsonNode validationResponse;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public AppConfigurationEndpoint(HttpServletRequest request, List<ConfigStore> configStores, Map<String, String> allRequestParams) throws IOException {
        JsonNode syncTokenNode;
        this.configStores = configStores;
        this.allRequestParams = allRequestParams;
        String reference = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
        JsonNode requestBody = OBJECT_MAPPER.readTree(reference);
        JsonNode data = requestBody.findValue("data");
        String sToken = null;
        if (data != null && (syncTokenNode = data.findValue("syncToken")) != null) {
            sToken = syncTokenNode.asText();
        }
        this.syncToken = sToken;
        this.validationResponse = requestBody.findValue("validationCode");
        JsonNode requestTopic = requestBody.findValue("topic");
        if (requestTopic == null) {
            throw new IllegalArgumentException("Refresh request missing topic field.");
        }
        String topic = requestTopic.asText();
        this.store = topic.substring(topic.toLowerCase(Locale.ROOT).indexOf(CONFIG_STORE_TOPIC) + CONFIG_STORE_TOPIC.length() + 1);
        this.endpoint = String.format("https://%s", this.store);
    }

    public boolean authenticate() {
        for (ConfigStore configStore : this.configStores) {
            if (!configStore.getEndpoint().startsWith(this.endpoint)) continue;
            AppConfigurationStoreMonitoring.PushNotification pushNotification = configStore.getMonitoring().getPushNotification();
            if (!pushNotification.getPrimaryToken().isValid() && !pushNotification.getSecondaryToken().isValid()) {
                return false;
            }
            if (this.isTokenMatch(pushNotification.getPrimaryToken())) {
                return true;
            }
            if (!this.isTokenMatch(pushNotification.getSecondaryToken())) continue;
            return true;
        }
        return false;
    }

    private boolean isTokenMatch(AppConfigurationStoreMonitoring.AccessToken token) {
        return token != null && this.allRequestParams.containsKey(token.getName()) && token.getSecret().equals(this.allRequestParams.get(token.getName()));
    }

    public boolean triggerRefresh() {
        for (ConfigStore configStore : this.configStores) {
            if (!configStore.getEndpoint().startsWith(this.endpoint) || !configStore.getMonitoring().isEnabled()) continue;
            return true;
        }
        return false;
    }

    public String getSyncToken() {
        return this.syncToken;
    }

    public JsonNode getValidationResponse() {
        return this.validationResponse;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getStore() {
        return this.store;
    }
}

