/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.web.implementation.pushbusrefresh;

import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationProperties;
import com.azure.spring.cloud.appconfiguration.config.web.implementation.AppConfigurationEndpoint;
import com.azure.spring.cloud.appconfiguration.config.web.implementation.pushbusrefresh.AppConfigurationBusRefreshEvent;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.cloud.bus.endpoint.AbstractBusEndpoint;
import org.springframework.cloud.bus.event.Destination;
import org.springframework.cloud.bus.event.PathDestinationFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerEndpoint(id="appconfiguration-refresh-bus")
public final class AppConfigurationBusRefreshEndpoint
extends AbstractBusEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationBusRefreshEndpoint.class);
    private final AppConfigurationProperties appConfiguration;

    public AppConfigurationBusRefreshEndpoint(ApplicationEventPublisher context, String appId, Destination.Factory destinationFactory, AppConfigurationProperties appConfiguration) {
        super(context, appId, destinationFactory);
        this.appConfiguration = appConfiguration;
    }

    @PostMapping(value={"/"})
    @ResponseBody
    public String refresh(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, String> allRequestParams) throws IOException {
        AppConfigurationEndpoint endpoint;
        try {
            endpoint = new AppConfigurationEndpoint(request, this.appConfiguration.getStores(), allRequestParams);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
            return HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase();
        }
        if (!endpoint.authenticate()) {
            return HttpStatus.UNAUTHORIZED.getReasonPhrase();
        }
        String syncToken = endpoint.getSyncToken();
        JsonNode validationResponse = endpoint.getValidationResponse();
        if (validationResponse != null) {
            return "{ \"validationResponse\": \"" + validationResponse.asText() + "\"}";
        }
        if (endpoint.triggerRefresh()) {
            this.publish((ApplicationEvent)new AppConfigurationBusRefreshEvent(endpoint.getEndpoint(), syncToken, this, this.getInstanceId(), new PathDestinationFactory().getDestination(null)));
            return HttpStatus.OK.getReasonPhrase();
        }
        LOGGER.debug("Non Refreshable notification");
        return HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase();
    }
}

