/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.web.implementation.pushbusrefresh;

import com.azure.spring.cloud.appconfiguration.config.AppConfigurationRefresh;
import com.azure.spring.cloud.appconfiguration.config.web.implementation.pushbusrefresh.AppConfigurationBusRefreshEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;

public final class AppConfigurationBusRefreshEventListener
implements ApplicationListener<AppConfigurationBusRefreshEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationBusRefreshEventListener.class);
    private final AppConfigurationRefresh appConfigurationRefresh;

    public AppConfigurationBusRefreshEventListener(AppConfigurationRefresh appConfigurationRefresh) {
        this.appConfigurationRefresh = appConfigurationRefresh;
    }

    public void onApplicationEvent(@NonNull AppConfigurationBusRefreshEvent event) {
        try {
            this.appConfigurationRefresh.expireRefreshInterval(event.getEndpoint(), event.getSyncToken());
        }
        catch (Exception e) {
            LOGGER.error("Refresh failed with unexpected exception.", (Throwable)e);
        }
    }
}

