/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagFilter;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationPropertySource;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.entity.Feature;
import com.azure.spring.cloud.appconfiguration.config.implementation.http.policy.TracingInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.util.StringUtils;

final class AppConfigurationFeatureManagementPropertySource
extends AppConfigurationPropertySource {
    private static final ObjectMapper CASE_INSENSITIVE_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
    private final List<ConfigurationSetting> featureConfigurationSettings = new ArrayList<ConfigurationSetting>();

    AppConfigurationFeatureManagementPropertySource(String originEndpoint, AppConfigurationReplicaClient replicaClient, String keyFilter, String[] labelFilter) {
        super("FM_" + originEndpoint, replicaClient, keyFilter, labelFilter);
    }

    private static List<Object> convertToListOrEmptyList(Map<String, Object> parameters, String key) {
        List listObjects = (List)CASE_INSENSITIVE_MAPPER.convertValue(parameters.get(key), (TypeReference)new TypeReference<List<Object>>(){});
        return listObjects == null ? Collections.emptyList() : listObjects;
    }

    public void initProperties() {
        SettingSelector settingSelector = new SettingSelector();
        String keyFilter = ".appconfig.featureflag/*";
        if (StringUtils.hasText((String)this.keyFilter)) {
            keyFilter = ".appconfig.featureflag/" + this.keyFilter;
        }
        settingSelector.setKeyFilter(keyFilter);
        List<String> labels = Arrays.asList(this.labelFilter);
        Collections.reverse(labels);
        for (String label : labels) {
            settingSelector.setLabelFilter(label);
            List<ConfigurationSetting> features = this.replicaClient.listSettings(settingSelector);
            TracingInfo tracing = this.replicaClient.getTracingInfo();
            for (ConfigurationSetting setting : features) {
                if (!(setting instanceof FeatureFlagConfigurationSetting) || !"application/vnd.microsoft.appconfig.ff+json;charset=utf-8".equals(setting.getContentType())) continue;
                this.featureConfigurationSettings.add(setting);
                FeatureFlagConfigurationSetting featureFlag = (FeatureFlagConfigurationSetting)setting;
                String configName = "feature-management." + setting.getKey().trim().substring(".appconfig.featureflag/".length());
                this.updateTelemetry(featureFlag, tracing);
                this.properties.put(configName, this.createFeature(featureFlag));
            }
        }
    }

    List<ConfigurationSetting> getFeatureFlagSettings() {
        return this.featureConfigurationSettings;
    }

    private Object createFeature(FeatureFlagConfigurationSetting item) {
        String key = this.getFeatureSimpleName((ConfigurationSetting)item);
        Feature feature = new Feature(key, item);
        Map<Integer, FeatureFlagFilter> featureEnabledFor = feature.getEnabledFor();
        if (featureEnabledFor.size() == 0 && item.isEnabled()) {
            return true;
        }
        if (!item.isEnabled()) {
            return false;
        }
        for (int filter = 0; filter < feature.getEnabledFor().size(); ++filter) {
            FeatureFlagFilter featureFilterEvaluationContext = featureEnabledFor.get(filter);
            Map parameters = featureFilterEvaluationContext.getParameters();
            if (parameters == null || !"targetingFilter".equals(featureEnabledFor.get(filter).getName())) continue;
            Object audienceObject = parameters.get("Audience");
            if (audienceObject != null) {
                parameters = (Map)audienceObject;
            }
            List<Object> users = AppConfigurationFeatureManagementPropertySource.convertToListOrEmptyList(parameters, "Users");
            List<Object> groupRollouts = AppConfigurationFeatureManagementPropertySource.convertToListOrEmptyList(parameters, "Groups");
            this.switchKeyValues(parameters, "Users", "users", this.mapValuesByIndex(users));
            this.switchKeyValues(parameters, "Groups", "groups", this.mapValuesByIndex(groupRollouts));
            this.switchKeyValues(parameters, "DefaultRolloutPercentage", "defaultRolloutPercentage", parameters.get("DefaultRolloutPercentage"));
            featureFilterEvaluationContext.setParameters(parameters);
            featureEnabledFor.put(filter, featureFilterEvaluationContext);
            feature.setEnabledFor(featureEnabledFor);
        }
        return feature;
    }

    private void updateTelemetry(FeatureFlagConfigurationSetting featureFlag, TracingInfo tracing) {
        for (FeatureFlagFilter filter : featureFlag.getClientFilters()) {
            tracing.getFeatureFlagTracing().updateFeatureFilterTelemetry(filter.getName());
        }
    }

    private String getFeatureSimpleName(ConfigurationSetting setting) {
        return setting.getKey().trim().substring(".appconfig.featureflag/".length());
    }

    private Map<String, Object> mapValuesByIndex(List<Object> users) {
        return IntStream.range(0, users.size()).boxed().collect(Collectors.toMap(String::valueOf, users::get));
    }

    private void switchKeyValues(Map<String, Object> parameters, String oldKey, String newKey, Object value) {
        parameters.put(newKey, value);
        parameters.remove(oldKey);
    }
}

