/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.data.appconfiguration.ConfigurationClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.env.EnumerablePropertySource;

abstract class AppConfigurationPropertySource
extends EnumerablePropertySource<ConfigurationClient> {
    protected final String keyFilter;
    protected final String[] labelFilter;
    protected final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    protected final AppConfigurationReplicaClient replicaClient;

    AppConfigurationPropertySource(String originEndpoint, AppConfigurationReplicaClient replicaClient, String keyFilter, String[] labelFilter) {
        super(keyFilter + originEndpoint + "/" + AppConfigurationPropertySource.getLabelName(labelFilter));
        this.replicaClient = replicaClient;
        this.keyFilter = keyFilter;
        this.labelFilter = labelFilter;
    }

    public String[] getPropertyNames() {
        Set<String> keySet = this.properties.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    private static String getLabelName(String[] labelFilter) {
        StringBuilder labelName = new StringBuilder();
        for (String label : labelFilter) {
            labelName.append(labelName.length() == 0 ? label : "," + label);
        }
        return labelName.toString();
    }
}

