/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.PagedIterable;
import com.azure.data.appconfiguration.ConfigurationClient;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationStatusException;
import com.azure.spring.cloud.appconfiguration.config.implementation.NormalizeNull;
import com.azure.spring.cloud.appconfiguration.config.implementation.http.policy.TracingInfo;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;

class AppConfigurationReplicaClient {
    private final String endpoint;
    private final ConfigurationClient client;
    private Instant backoffEndTime;
    private int failedAttempts;
    private final TracingInfo tracingInfo;

    AppConfigurationReplicaClient(String endpoint, ConfigurationClient client, TracingInfo tracingInfo) {
        this.endpoint = endpoint;
        this.client = client;
        this.backoffEndTime = Instant.now().minusMillis(1L);
        this.failedAttempts = 0;
        this.tracingInfo = tracingInfo;
    }

    Instant getBackoffEndTime() {
        return this.backoffEndTime;
    }

    void updateBackoffEndTime(Instant backoffEndTime) {
        this.backoffEndTime = backoffEndTime;
        ++this.failedAttempts;
    }

    int getFailedAttempts() {
        return this.failedAttempts;
    }

    String getEndpoint() {
        return this.endpoint;
    }

    ConfigurationSetting getWatchKey(String key, String label) throws HttpResponseException {
        try {
            ConfigurationSetting watchKey = NormalizeNull.normalizeNullLabel(this.client.getConfigurationSetting(key, label));
            this.failedAttempts = 0;
            return watchKey;
        }
        catch (HttpResponseException e) {
            int statusCode = e.getResponse().getStatusCode();
            if (statusCode == 429 || statusCode == 408 || statusCode >= 500) {
                throw new AppConfigurationStatusException(e.getMessage(), e.getResponse(), e.getValue());
            }
            throw e;
        }
        catch (Exception e) {
            if (e.getMessage().startsWith("java.net.UnknownHostException") || e.getMessage().startsWith("java.net.WebSocketHandshakeException") || e.getMessage().startsWith("java.net.SocketException") || e.getMessage().startsWith("java.io.IOException") || e.getMessage().startsWith("io.netty.channel.AbstractChannel$AnnotatedConnectException: Connection refused")) {
                throw new AppConfigurationStatusException(e.getMessage(), null, null);
            }
            throw e;
        }
    }

    List<ConfigurationSetting> listSettings(SettingSelector settingSelector) throws HttpResponseException {
        ArrayList<ConfigurationSetting> configurationSettings = new ArrayList<ConfigurationSetting>();
        try {
            PagedIterable settings = this.client.listConfigurationSettings(settingSelector);
            this.failedAttempts = 0;
            settings.forEach(setting -> configurationSettings.add(NormalizeNull.normalizeNullLabel(setting)));
            return configurationSettings;
        }
        catch (HttpResponseException e) {
            int statusCode = e.getResponse().getStatusCode();
            if (statusCode == 429 || statusCode == 408 || statusCode >= 500) {
                throw new AppConfigurationStatusException(e.getMessage(), e.getResponse(), e.getValue());
            }
            throw e;
        }
        catch (Exception e) {
            if (e.getMessage().startsWith("java.net.UnknownHostException") || e.getMessage().startsWith("java.net.WebSocketHandshakeException") || e.getMessage().startsWith("java.net.SocketException") || e.getMessage().startsWith("java.io.IOException") || e.getMessage().startsWith("io.netty.channel.AbstractChannel$AnnotatedConnectException: Connection refused")) {
                throw new AppConfigurationStatusException(e.getMessage(), null, null);
            }
            throw e;
        }
    }

    void updateSyncToken(String syncToken) {
        if (StringUtils.hasText((String)syncToken)) {
            this.client.updateSyncToken(syncToken);
        }
    }

    TracingInfo getTracingInfo() {
        return this.tracingInfo;
    }
}

