/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.data.appconfiguration.models.SecretReferenceConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationKeyVaultClientFactory;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationPropertySource;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.JsonConfigurationParser;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.util.StringUtils;

class AppConfigurationApplicationSettingPropertySource
extends AppConfigurationPropertySource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationApplicationSettingPropertySource.class);
    private final AppConfigurationKeyVaultClientFactory keyVaultClientFactory;
    private final String keyFilter;
    private final String[] labelFilters;

    AppConfigurationApplicationSettingPropertySource(String name, AppConfigurationReplicaClient replicaClient, AppConfigurationKeyVaultClientFactory keyVaultClientFactory, String keyFilter, String[] labelFilters) {
        super(name + AppConfigurationApplicationSettingPropertySource.getLabelName(labelFilters), replicaClient);
        this.keyVaultClientFactory = keyVaultClientFactory;
        this.keyFilter = keyFilter;
        this.labelFilters = labelFilters;
    }

    @Override
    public void initProperties(List<String> keyPrefixTrimValues) throws InvalidConfigurationPropertyValueException {
        List<String> labels = Arrays.asList(this.labelFilters);
        Collections.reverse(labels);
        for (String label : labels) {
            SettingSelector settingSelector = new SettingSelector().setKeyFilter(this.keyFilter + "*").setLabelFilter(label);
            this.processConfigurationSettings(this.replicaClient.listSettings(settingSelector), settingSelector.getKeyFilter(), keyPrefixTrimValues);
        }
    }

    protected void processConfigurationSettings(List<ConfigurationSetting> settings, String keyFilter, List<String> keyPrefixTrimValues) throws InvalidConfigurationPropertyValueException {
        for (ConfigurationSetting setting : settings) {
            if (keyPrefixTrimValues == null && StringUtils.hasText((String)keyFilter)) {
                keyPrefixTrimValues = new ArrayList<String>();
                keyPrefixTrimValues.add(keyFilter.substring(0, keyFilter.length() - 1));
            }
            String key = this.trimKey(setting.getKey(), keyPrefixTrimValues);
            if (setting instanceof SecretReferenceConfigurationSetting) {
                this.handleKeyVaultReference(key, (SecretReferenceConfigurationSetting)setting);
                continue;
            }
            if (setting instanceof FeatureFlagConfigurationSetting && "application/vnd.microsoft.appconfig.ff+json;charset=utf-8".equals(setting.getContentType())) {
                this.handleFeatureFlag(key, (FeatureFlagConfigurationSetting)setting, keyPrefixTrimValues);
                continue;
            }
            if (StringUtils.hasText((String)setting.getContentType()) && JsonConfigurationParser.isJsonContentType(setting.getContentType())) {
                this.handleJson(setting, keyPrefixTrimValues);
                continue;
            }
            this.properties.put(key, setting.getValue());
        }
    }

    protected void handleKeyVaultReference(String key, SecretReferenceConfigurationSetting secretReference) throws InvalidConfigurationPropertyValueException {
        try {
            URI uri = new URI(secretReference.getSecretId());
            KeyVaultSecret secret = this.keyVaultClientFactory.getClient("https://" + uri.getHost()).getSecret(uri);
            this.properties.put(key, secret.getValue());
        }
        catch (URISyntaxException e) {
            LOGGER.error(String.format("Error Retrieving Key Vault Entry for key %s.", key));
            throw new InvalidConfigurationPropertyValueException(key, (Object)"<Redacted>", "Invalid URI found in JSON property field 'uri' unable to parse.");
        }
        catch (RuntimeException e) {
            LOGGER.error(String.format("Error Retrieving Key Vault Entry for key %s.", key));
            throw e;
        }
    }

    void handleFeatureFlag(String key, FeatureFlagConfigurationSetting setting, List<String> trimStrings) throws InvalidConfigurationPropertyValueException {
        this.handleJson((ConfigurationSetting)setting, trimStrings);
    }

    void handleJson(ConfigurationSetting setting, List<String> keyPrefixTrimValues) throws InvalidConfigurationPropertyValueException {
        Map<String, Object> jsonSettings = JsonConfigurationParser.parseJsonSetting(setting);
        for (Map.Entry<String, Object> jsonSetting : jsonSettings.entrySet()) {
            String key = this.trimKey(jsonSetting.getKey(), keyPrefixTrimValues);
            this.properties.put(key, jsonSetting.getValue());
        }
    }

    protected String trimKey(String key, List<String> trimStrings) {
        key = key.trim();
        if (trimStrings != null) {
            for (String trim : trimStrings) {
                if (!key.startsWith(trim)) continue;
                return key.replaceFirst("^" + trim, "").replace('/', '.');
            }
        }
        return key.replace("/", ".");
    }
}

